/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.compression.BufferDecompressionException;
import org.apache.paimon.compression.CompressorUtils;
import org.apache.paimon.shade.io.airlift.compress.Decompressor;
import org.apache.paimon.shade.io.airlift.compress.MalformedInputException;

public class AirBlockDecompressor
implements BlockDecompressor {
    private final Decompressor internalDecompressor;

    public AirBlockDecompressor(Decompressor internalDecompressor) {
        this.internalDecompressor = internalDecompressor;
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferDecompressionException {
        int compressedLen = CompressorUtils.readIntLE(src, srcOff);
        int originalLen = CompressorUtils.readIntLE(src, srcOff + 4);
        CompressorUtils.validateLength(compressedLen, originalLen);
        if (dst.length - dstOff < originalLen) {
            throw new BufferDecompressionException("Buffer length too small");
        }
        if (src.length - srcOff - 8 < compressedLen) {
            throw new BufferDecompressionException("Source data is not integral for decompression.");
        }
        try {
            int decompressedLen = this.internalDecompressor.decompress(src, srcOff + 8, compressedLen, dst, dstOff, originalLen);
            if (originalLen != decompressedLen) {
                throw new BufferDecompressionException("Input is corrupted");
            }
        }
        catch (MalformedInputException e) {
            throw new BufferDecompressionException("Input is corrupted", e);
        }
        return originalLen;
    }
}

