/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;

public class FlinkGenericTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private final Factory paimon;
    private final Factory flink;

    public FlinkGenericTableFactory(Factory paimon, Factory flink) {
        this.paimon = paimon;
        this.flink = flink;
    }

    public String factoryIdentifier() {
        throw new UnsupportedOperationException("Generic factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> requiredOptions() {
        throw new UnsupportedOperationException("Generic factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> optionalOptions() {
        throw new UnsupportedOperationException("Generic factory is only work for catalog.");
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        boolean isFlink = context.getCatalogTable().getOptions().containsKey(FactoryUtil.CONNECTOR.key());
        if (isFlink) {
            return ((DynamicTableSinkFactory)this.flink).createDynamicTableSink(context);
        }
        return ((DynamicTableSinkFactory)this.paimon).createDynamicTableSink(context);
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        boolean isFlink = context.getCatalogTable().getOptions().containsKey(FactoryUtil.CONNECTOR.key());
        if (isFlink) {
            return ((DynamicTableSourceFactory)this.flink).createDynamicTableSource(context);
        }
        return ((DynamicTableSourceFactory)this.paimon).createDynamicTableSource(context);
    }
}

