/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.DateTimeUtils;

public interface CdcMetadataConverter
extends Serializable {
    public String read(JsonNode var1);

    public DataType dataType();

    public String columnName();

    public static class OpTsConverter
    implements CdcMetadataConverter {
        private static final long serialVersionUID = 1L;

        @Override
        public String read(JsonNode source) {
            return DateTimeUtils.formatTimestamp(Timestamp.fromEpochMillis(source.get("ts_ms").asLong()), TimeZone.getDefault(), 3);
        }

        @Override
        public DataType dataType() {
            return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(3).notNull();
        }

        @Override
        public String columnName() {
            return "op_ts";
        }
    }

    public static class SchemaNameConverter
    implements CdcMetadataConverter {
        private static final long serialVersionUID = 1L;

        @Override
        public String read(JsonNode source) {
            return source.get("schema").asText();
        }

        @Override
        public DataType dataType() {
            return DataTypes.STRING().notNull();
        }

        @Override
        public String columnName() {
            return "schema_name";
        }
    }

    public static class TableNameConverter
    implements CdcMetadataConverter {
        private static final long serialVersionUID = 1L;

        @Override
        public String read(JsonNode source) {
            return source.get("table").asText();
        }

        @Override
        public DataType dataType() {
            return DataTypes.STRING().notNull();
        }

        @Override
        public String columnName() {
            return "table_name";
        }
    }

    public static class DatabaseNameConverter
    implements CdcMetadataConverter {
        private static final long serialVersionUID = 1L;

        @Override
        public String read(JsonNode source) {
            return source.get("db").asText();
        }

        @Override
        public DataType dataType() {
            return DataTypes.STRING().notNull();
        }

        @Override
        public String columnName() {
            return "database_name";
        }
    }
}

