/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.data.columnar.writable.WritableLongVector;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.reader.AbstractColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReader;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;

public class FixedLenBytesColumnReader<VECTOR extends WritableColumnVector>
extends AbstractColumnReader<VECTOR> {
    private final int precision;

    public FixedLenBytesColumnReader(ColumnDescriptor descriptor, PageReader pageReader, int precision) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        this.precision = precision;
    }

    @Override
    protected void readBatch(int rowId, int num, VECTOR column) {
        int bytesLen = this.descriptor.getPrimitiveType().getTypeLength();
        if (ParquetSchemaConverter.is32BitDecimal(this.precision)) {
            WritableIntVector intVector = (WritableIntVector)column;
            for (int i = 0; i < num; ++i) {
                if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                    intVector.setInt(rowId + i, (int)this.heapBinaryToLong(this.readDataBinary(bytesLen)));
                    continue;
                }
                intVector.setNullAt(rowId + i);
            }
        } else if (ParquetSchemaConverter.is64BitDecimal(this.precision)) {
            WritableLongVector longVector = (WritableLongVector)column;
            for (int i = 0; i < num; ++i) {
                if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                    longVector.setLong(rowId + i, this.heapBinaryToLong(this.readDataBinary(bytesLen)));
                    continue;
                }
                longVector.setNullAt(rowId + i);
            }
        } else {
            WritableBytesVector bytesVector = (WritableBytesVector)column;
            for (int i = 0; i < num; ++i) {
                if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                    byte[] bytes = this.readDataBinary(bytesLen).getBytesUnsafe();
                    bytesVector.appendBytes(rowId + i, bytes, 0, bytes.length);
                    continue;
                }
                bytesVector.setNullAt(rowId + i);
            }
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, VECTOR column, WritableIntVector dictionaryIds) {
        if (ParquetSchemaConverter.is32BitDecimal(this.precision)) {
            WritableIntVector intVector = (WritableIntVector)column;
            for (int i = rowId; i < rowId + num; ++i) {
                if (intVector.isNullAt(i)) continue;
                Binary v = this.dictionary.decodeToBinary(dictionaryIds.getInt(i));
                intVector.setInt(i, (int)this.heapBinaryToLong(v));
            }
        } else if (ParquetSchemaConverter.is64BitDecimal(this.precision)) {
            WritableLongVector longVector = (WritableLongVector)column;
            for (int i = rowId; i < rowId + num; ++i) {
                if (longVector.isNullAt(i)) continue;
                Binary v = this.dictionary.decodeToBinary(dictionaryIds.getInt(i));
                longVector.setLong(i, this.heapBinaryToLong(v));
            }
        } else {
            WritableBytesVector bytesVector = (WritableBytesVector)column;
            for (int i = rowId; i < rowId + num; ++i) {
                if (bytesVector.isNullAt(i)) continue;
                byte[] v = this.dictionary.decodeToBinary(dictionaryIds.getInt(i)).getBytesUnsafe();
                bytesVector.appendBytes(i, v, 0, v.length);
            }
        }
    }

    private long heapBinaryToLong(Binary binary) {
        ByteBuffer buffer = binary.toByteBuffer();
        byte[] bytes = buffer.array();
        int start = buffer.arrayOffset() + buffer.position();
        int end = buffer.arrayOffset() + buffer.limit();
        long unscaled = 0L;
        for (int i = start; i < end; ++i) {
            unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
        }
        int bits = 8 * (end - start);
        return unscaled << 64 - bits >> 64 - bits;
    }

    private Binary readDataBinary(int len) {
        ByteBuffer buffer = this.readDataBuffer(len);
        if (buffer.hasArray()) {
            return Binary.fromConstantByteArray(buffer.array(), buffer.arrayOffset() + buffer.position(), len);
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return Binary.fromConstantByteArray(bytes);
    }
}

