/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.LinkedHashMap;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.Pair;

public class IndexFileMetaSerializer
extends ObjectSerializer<IndexFileMeta> {
    public IndexFileMetaSerializer() {
        super(IndexFileMeta.SCHEMA);
    }

    @Override
    public InternalRow toRow(IndexFileMeta record) {
        return GenericRow.of(BinaryString.fromString(record.indexType()), BinaryString.fromString(record.fileName()), record.fileSize(), record.rowCount(), record.deletionVectorsRanges() == null ? null : IndexFileMetaSerializer.dvRangesToRowArrayData(record.deletionVectorsRanges()));
    }

    @Override
    public IndexFileMeta fromRow(InternalRow row) {
        return new IndexFileMeta(row.getString(0).toString(), row.getString(1).toString(), row.getLong(2), row.getLong(3), row.isNullAt(4) ? null : IndexFileMetaSerializer.rowArrayDataToDvRanges(row.getArray(4)));
    }

    public static InternalArray dvRangesToRowArrayData(LinkedHashMap<String, Pair<Integer, Integer>> dvRanges) {
        return new GenericArray(dvRanges.entrySet().stream().map(entry -> GenericRow.of(BinaryString.fromString((String)entry.getKey()), ((Pair)entry.getValue()).getLeft(), ((Pair)entry.getValue()).getRight())).toArray(GenericRow[]::new));
    }

    public static LinkedHashMap<String, Pair<Integer, Integer>> rowArrayDataToDvRanges(InternalArray arrayData) {
        LinkedHashMap<String, Pair<Integer, Integer>> dvRanges = new LinkedHashMap<String, Pair<Integer, Integer>>(arrayData.size());
        for (int i = 0; i < arrayData.size(); ++i) {
            InternalRow row = arrayData.getRow(i, 3);
            dvRanges.put(row.getString(0).toString(), Pair.of(row.getInt(1), row.getInt(2)));
        }
        return dvRanges;
    }
}

