/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.sort.BlockHandle;
import org.apache.paimon.lookup.sort.BlockIterator;
import org.apache.paimon.lookup.sort.BlockReader;
import org.apache.paimon.lookup.sort.BlockTrailer;
import org.apache.paimon.lookup.sort.Footer;
import org.apache.paimon.lookup.sort.SortContext;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceInput;
import org.apache.paimon.utils.Preconditions;

public class SortLookupStoreReader
implements LookupStoreReader {
    private final Comparator<MemorySlice> comparator;
    private final FileChannel fileChannel;
    private final long fileSize;
    private final BlockIterator indexBlockIterator;

    public SortLookupStoreReader(Comparator<MemorySlice> comparator, File file, SortContext context, CacheManager cacheManager) throws IOException {
        this.comparator = comparator;
        this.fileChannel = new FileInputStream(file).getChannel();
        this.fileSize = context.fileSize();
        Footer footer = this.readFooter();
        this.indexBlockIterator = this.readBlock(footer.getIndexBlockHandle()).iterator();
    }

    private Footer readFooter() throws IOException {
        MemorySegment footerData = this.read(this.fileSize - 36L, 36);
        return Footer.readFooter(MemorySlice.wrap(footerData).toInput());
    }

    @Override
    @Nullable
    public byte[] lookup(byte[] key) throws IOException {
        BlockIterator current;
        MemorySlice keySlice = MemorySlice.wrap(key);
        this.indexBlockIterator.seekTo(keySlice);
        if (this.indexBlockIterator.hasNext() && (current = this.getNextBlock()).seekTo(keySlice)) {
            return current.next().getValue().copyBytes();
        }
        return null;
    }

    private BlockIterator getNextBlock() throws IOException {
        MemorySlice blockHandle = this.indexBlockIterator.next().getValue();
        BlockReader dataBlock = this.openBlock(blockHandle);
        return dataBlock.iterator();
    }

    private BlockReader openBlock(MemorySlice blockEntry) throws IOException {
        BlockHandle blockHandle = BlockHandle.readBlockHandle(blockEntry.toInput());
        return this.readBlock(blockHandle);
    }

    private MemorySegment read(long offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        int read = this.fileChannel.read(ByteBuffer.wrap(buffer), offset);
        if (read != length) {
            throw new IOException("Could not read all the data");
        }
        return MemorySegment.wrap(buffer);
    }

    private BlockReader readBlock(BlockHandle blockHandle) throws IOException {
        MemorySlice uncompressedData;
        MemorySegment trailerData = this.read(blockHandle.offset() + (long)blockHandle.size(), 5);
        BlockTrailer blockTrailer = BlockTrailer.readBlockTrailer(MemorySlice.wrap(trailerData).toInput());
        MemorySegment block = this.read(blockHandle.offset(), blockHandle.size());
        BlockCompressionFactory compressionFactory = BlockCompressionFactory.create(blockTrailer.getCompressionType());
        if (compressionFactory == null) {
            uncompressedData = MemorySlice.wrap(block);
        } else {
            MemorySliceInput compressedInput = MemorySlice.wrap(block).toInput();
            byte[] uncompressed = new byte[compressedInput.readVarLenInt()];
            BlockDecompressor decompressor = compressionFactory.getDecompressor();
            int uncompressedLength = decompressor.decompress(block.getHeapMemory(), compressedInput.position(), compressedInput.available(), uncompressed, 0);
            Preconditions.checkArgument(uncompressedLength == uncompressed.length);
            uncompressedData = MemorySlice.wrap(uncompressed);
        }
        return new BlockReader(uncompressedData, this.comparator);
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

