/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.statistics;

import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.statistics.CountsSimpleColStatsCollector;
import org.apache.paimon.statistics.FullSimpleColStatsCollector;
import org.apache.paimon.statistics.NoneSimpleColStatsCollector;
import org.apache.paimon.statistics.TruncateSimpleColStatsCollector;

public interface SimpleColStatsCollector {
    public void collect(Object var1, Serializer<Object> var2);

    public SimpleColStats result();

    public SimpleColStats convert(SimpleColStats var1);

    public static SimpleColStatsCollector[] create(Factory[] factories) {
        SimpleColStatsCollector[] collectors = new SimpleColStatsCollector[factories.length];
        for (int i = 0; i < factories.length; ++i) {
            collectors[i] = factories[i].create();
        }
        return collectors;
    }

    public static Factory from(String option) {
        String upper;
        switch (upper = option.toUpperCase()) {
            case "NONE": {
                return NoneSimpleColStatsCollector::new;
            }
            case "FULL": {
                return FullSimpleColStatsCollector::new;
            }
            case "COUNTS": {
                return CountsSimpleColStatsCollector::new;
            }
        }
        Matcher matcher = TruncateSimpleColStatsCollector.TRUNCATE_PATTERN.matcher(upper);
        if (matcher.matches()) {
            String length = matcher.group(1);
            return () -> new TruncateSimpleColStatsCollector(Integer.parseInt(length));
        }
        throw new IllegalArgumentException("Unexpected option: " + option);
    }

    public static Factory[] createFullStatsFactories(int numFields) {
        Object[] factories = new Factory[numFields];
        Arrays.fill(factories, FullSimpleColStatsCollector::new);
        return factories;
    }

    public static interface Factory {
        public SimpleColStatsCollector create();
    }
}

