/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.InnerTable;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.Projection;
import org.apache.paimon.utils.TypeUtils;

public class ReadBuilderImpl
implements ReadBuilder {
    private static final long serialVersionUID = 1L;
    private final InnerTable table;
    private Predicate filter;
    private int[][] projection;
    private Integer limit = null;
    private Integer shardIndexOfThisSubtask;
    private Integer shardNumberOfParallelSubtasks;
    private Map<String, String> partitionSpec;
    private Filter<Integer> bucketFilter;

    public ReadBuilderImpl(InnerTable table) {
        this.table = table;
    }

    @Override
    public String tableName() {
        return this.table.name();
    }

    @Override
    public RowType readType() {
        if (this.projection == null) {
            return this.table.rowType();
        }
        return TypeUtils.project(this.table.rowType(), Projection.of(this.projection).toTopLevelIndexes());
    }

    @Override
    public ReadBuilder withFilter(Predicate filter) {
        this.filter = this.filter == null ? filter : PredicateBuilder.and(this.filter, filter);
        return this;
    }

    @Override
    public ReadBuilder withPartitionFilter(Map<String, String> partitionSpec) {
        this.partitionSpec = partitionSpec;
        return this;
    }

    @Override
    public ReadBuilder withProjection(int[][] projection) {
        this.projection = projection;
        return this;
    }

    @Override
    public ReadBuilder withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public ReadBuilder withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
        this.shardIndexOfThisSubtask = indexOfThisSubtask;
        this.shardNumberOfParallelSubtasks = numberOfParallelSubtasks;
        return this;
    }

    @Override
    public ReadBuilder withBucketFilter(Filter<Integer> bucketFilter) {
        this.bucketFilter = bucketFilter;
        return this;
    }

    @Override
    public TableScan newScan() {
        InnerTableScan tableScan = this.configureScan(this.table.newScan());
        if (this.limit != null) {
            tableScan.withLimit(this.limit);
        }
        return tableScan;
    }

    @Override
    public StreamTableScan newStreamScan() {
        return (StreamTableScan)((Object)this.configureScan(this.table.newStreamScan()));
    }

    private InnerTableScan configureScan(InnerTableScan scan) {
        scan.withFilter(this.filter).withPartitionFilter(this.partitionSpec);
        Preconditions.checkState(this.bucketFilter == null || this.shardIndexOfThisSubtask == null, "Bucket filter and shard configuration cannot be used together. Please choose one method to specify the data subset.");
        if (this.shardIndexOfThisSubtask != null) {
            if (scan instanceof DataTableScan) {
                return ((DataTableScan)scan).withShard(this.shardIndexOfThisSubtask, this.shardNumberOfParallelSubtasks);
            }
            throw new UnsupportedOperationException("Unsupported table scan type for shard configuring, the scan is: " + scan);
        }
        if (this.bucketFilter != null) {
            scan.withBucketFilter(this.bucketFilter);
        }
        return scan;
    }

    @Override
    public TableRead newRead() {
        InnerTableRead read = this.table.newRead().withFilter(this.filter);
        if (this.projection != null) {
            read.withProjection(this.projection);
        }
        return read;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBuilderImpl that = (ReadBuilderImpl)o;
        return Objects.equals(this.table.name(), that.table.name()) && Objects.equals(this.filter, that.filter) && Arrays.deepEquals((Object[])this.projection, (Object[])that.projection);
    }

    public int hashCode() {
        int result = Objects.hash(this.table.name(), this.filter);
        result = 31 * result + Arrays.deepHashCode((Object[])this.projection);
        return result;
    }
}

