/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.lineage.LineageMetaFactory;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.AggregationFieldsTable;
import org.apache.paimon.table.system.AllTableOptionsTable;
import org.apache.paimon.table.system.AuditLogTable;
import org.apache.paimon.table.system.BranchesTable;
import org.apache.paimon.table.system.CatalogOptionsTable;
import org.apache.paimon.table.system.ConsumersTable;
import org.apache.paimon.table.system.FilesTable;
import org.apache.paimon.table.system.ManifestsTable;
import org.apache.paimon.table.system.OptionsTable;
import org.apache.paimon.table.system.PartitionsTable;
import org.apache.paimon.table.system.ReadOptimizedTable;
import org.apache.paimon.table.system.SchemasTable;
import org.apache.paimon.table.system.SinkTableLineageTable;
import org.apache.paimon.table.system.SnapshotsTable;
import org.apache.paimon.table.system.SourceTableLineageTable;
import org.apache.paimon.table.system.StatisticTable;
import org.apache.paimon.table.system.TagsTable;
import org.apache.paimon.utils.Preconditions;

public class SystemTableLoader {
    public static final Map<String, Function<FileStoreTable, Table>> SYSTEM_TABLE_LOADERS = new ImmutableMap.Builder<String, Function<FileStoreTable, Table>>().put("manifests", ManifestsTable::new).put("snapshots", SnapshotsTable::new).put("options", OptionsTable::new).put("schemas", SchemasTable::new).put("partitions", PartitionsTable::new).put("audit_log", AuditLogTable::new).put("files", FilesTable::new).put("tags", TagsTable::new).put("branches", BranchesTable::new).put("consumers", ConsumersTable::new).put("ro", ReadOptimizedTable::new).put("aggregation_fields", AggregationFieldsTable::new).put("statistics", StatisticTable::new).build();
    public static final List<String> SYSTEM_TABLES = new ArrayList<String>(SYSTEM_TABLE_LOADERS.keySet());

    @Nullable
    public static Table load(String type, FileStoreTable dataTable) {
        return Optional.ofNullable(SYSTEM_TABLE_LOADERS.get(type.toLowerCase())).map(f -> (Table)f.apply(dataTable)).orElse(null);
    }

    @Nullable
    public static Table loadGlobal(String tableName, FileIO fileIO, Supplier<Map<String, Map<String, Path>>> allTablePaths, Options catalogOptions, @Nullable LineageMetaFactory lineageMetaFactory) {
        switch (tableName.toLowerCase()) {
            case "all_table_options": {
                return new AllTableOptionsTable(fileIO, allTablePaths.get());
            }
            case "catalog_options": {
                return new CatalogOptionsTable(catalogOptions);
            }
            case "source_table_lineage": {
                Preconditions.checkNotNull(lineageMetaFactory, String.format("Lineage meta should be configured for catalog with %s", CatalogOptions.LINEAGE_META.key()));
                return new SourceTableLineageTable(lineageMetaFactory, catalogOptions);
            }
            case "sink_table_lineage": {
                Preconditions.checkNotNull(lineageMetaFactory, String.format("Lineage meta should be configured for catalog with %s", CatalogOptions.LINEAGE_META.key()));
                return new SinkTableLineageTable(lineageMetaFactory, catalogOptions);
            }
        }
        return null;
    }

    public static List<String> loadGlobalTableNames() {
        return Arrays.asList("all_table_options", "catalog_options", "source_table_lineage", "sink_table_lineage");
    }
}

