/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafPredicateExtractor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.TagManager;

public class TagsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String TAGS = "tags";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "tag_name", SerializationUtils.newStringType(false)), new DataField(1, "snapshot_id", new BigIntType(false)), new DataField(2, "schema_id", new BigIntType(false)), new DataField(3, "commit_time", new TimestampType(false, 3)), new DataField(4, "record_count", new BigIntType(true)), new DataField(5, "create_time", new TimestampType(true, 3)), new DataField(6, "time_retained", SerializationUtils.newStringType(true))));
    private final FileIO fileIO;
    private final Path location;
    private final String branch;

    public TagsTable(FileStoreTable dataTable) {
        this(dataTable.fileIO(), dataTable.location(), CoreOptions.branch(dataTable.schema().options()));
    }

    public TagsTable(FileIO fileIO, Path location, String branchName) {
        this.fileIO = fileIO;
        this.location = location;
        this.branch = branchName;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + TAGS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("tag_name");
    }

    @Override
    public InnerTableScan newScan() {
        return new TagsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new TagsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new TagsTable(this.fileIO, this.location, this.branch);
    }

    private class TagsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;

        public TagsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof TagsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((TagsSplit)split).location;
            LeafPredicate predicate = ((TagsSplit)split).tagName;
            TagManager tagManager = new TagManager(this.fileIO, location, TagsTable.this.branch);
            LinkedHashMap<Object, Tag> nameToSnapshot = new LinkedHashMap<Object, Tag>();
            if (predicate != null && predicate.function() instanceof Equal && predicate.literals().get(0) instanceof BinaryString) {
                String equalValue = predicate.literals().get(0).toString();
                if (tagManager.tagExists(equalValue)) {
                    nameToSnapshot.put(equalValue, tagManager.tag(equalValue));
                }
            } else {
                for (Pair<Tag, String> tag : tagManager.tagObjects()) {
                    nameToSnapshot.put(tag.getValue(), tag.getKey());
                }
            }
            Iterator rows = Iterators.transform(nameToSnapshot.entrySet().iterator(), this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Map.Entry<String, Tag> snapshot) {
            Tag tag = snapshot.getValue();
            return GenericRow.of(BinaryString.fromString(snapshot.getKey()), tag.id(), tag.schemaId(), Timestamp.fromLocalDateTime(DateTimeUtils.toLocalDateTime(tag.timeMillis())), tag.totalRecordCount(), Optional.ofNullable(tag.getTagCreateTime()).map(Timestamp::fromLocalDateTime).orElse(null), Optional.ofNullable(tag.getTagTimeRetained()).map(Object::toString).map(BinaryString::fromString).orElse(null));
        }
    }

    private static class TagsSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;
        @Nullable
        private final LeafPredicate tagName;

        private TagsSplit(Path location, @Nullable LeafPredicate tagName) {
            this.location = location;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagsSplit that = (TagsSplit)o;
            return Objects.equals(this.location, that.location) && Objects.equals(this.tagName, that.tagName);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class TagsScan
    extends ReadOnceTableScan {
        @Nullable
        private LeafPredicate tagName;

        private TagsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            if (predicate == null) {
                return this;
            }
            Map<String, LeafPredicate> leafPredicates = predicate.visit(LeafPredicateExtractor.INSTANCE);
            this.tagName = leafPredicates.get("tag_name");
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new TagsSplit(TagsTable.this.location, this.tagName));
        }
    }
}

