/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CompactActionFactory;
import org.apache.paimon.flink.action.CompactDatabaseAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.utils.TimeUtils;

public class CompactDatabaseActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "compact_database";
    private static final String INCLUDING_DATABASES = "including_databases";
    private static final String INCLUDING_TABLES = "including_tables";
    private static final String EXCLUDING_TABLES = "excluding_tables";
    private static final String MODE = "mode";
    private static final String PARTITION_IDLE_TIME = "partition_idle_time";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String compactStrategy;
        CompactDatabaseAction action = new CompactDatabaseAction(this.catalogConfigMap(params));
        action.includingDatabases(params.get(INCLUDING_DATABASES)).includingTables(params.get(INCLUDING_TABLES)).excludingTables(params.get(EXCLUDING_TABLES)).withDatabaseCompactMode(params.get(MODE)).withTableOptions(this.optionalConfigMap(params, "table_conf"));
        String partitionIdleTime = params.get(PARTITION_IDLE_TIME);
        if (partitionIdleTime != null) {
            action.withPartitionIdleTime(TimeUtils.parseDuration(partitionIdleTime));
        }
        if (CompactActionFactory.checkCompactStrategy(compactStrategy = params.get("compact_strategy"))) {
            action.withFullCompaction(compactStrategy.trim().equalsIgnoreCase("full"));
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"compact_database\" runs a dedicated job for compacting one or multiple database.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  compact_database --warehouse <warehouse_path> --including_databases <database-name|name-regular-expr> [--including_tables <paimon_table_name|name_regular_expr>] [--excluding_tables <paimon_table_name|name_regular_expr>] [--mode <compact_mode>][--partition_idle_time <partition_idle_time>][--compact_strategy <compact_strategy>]");
        System.out.println("  compact_database --warehouse s3://path/to/warehouse --including_databases <database-name|name-regular-expr> [--catalog_conf <paimon_catalog_conf> [--catalog_conf <paimon_catalog_conf> ...]]");
        System.out.println();
        System.out.println("--including_databases is used to specify which databases are to be compacted. You must use '|' to separate multiple databases, Regular expression is supported.");
        System.out.println("--including_tables is used to specify which source tables are to be compacted. You must use '|' to separate multiple tables, the format is `databaseName.tableName`, Regular expression is supported.");
        System.out.println("--excluding_tables is used to specify which source tables are not to be compacted. The usage is same as --including_tables.");
        System.out.println("--excluding_tables has higher priority than --including_tables if you specified both.");
        System.out.println("--mode is used to specify compaction mode. Possible values: divided, combined.");
        System.out.println("--partition_idle_time is used to do a full compaction for partition which had not receive any new data for 'partition_idle_time' time. And only these partitions will be compacted.");
        System.out.println("--partition_idle_time is only supported in batch mode. ");
        System.out.println("--compact_strategy determines how to pick files to be merged, the default is determined by the runtime execution mode. `full` : Only supports batch mode. All files will be selected for merging.`minor`: Pick the set of files that need to be merged based on specified conditions.");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  compact_database --warehouse hdfs:///path/to/warehouse --including_databases test_db");
        System.out.println("  compact_database --warehouse s3:///path/to/warehouse --including_databases test_db --catalog_conf s3.endpoint=https://****.com --catalog_conf s3.access-key=***** --catalog_conf s3.secret-key=***** ");
    }
}

