/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact.changelog;

import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.types.Either;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactTask;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.table.FileStoreTable;

public class ChangelogCompactWorkerOperator
extends AbstractStreamOperator<Committable>
implements OneInputStreamOperator<Either<Committable, ChangelogCompactTask>, Committable> {
    private final FileStoreTable table;

    public ChangelogCompactWorkerOperator(FileStoreTable table) {
        this.table = table;
    }

    public void processElement(StreamRecord<Either<Committable, ChangelogCompactTask>> record) throws Exception {
        if (((Either)record.getValue()).isLeft()) {
            this.output.collect((Object)new StreamRecord(((Either)record.getValue()).left()));
        } else {
            ChangelogCompactTask task = (ChangelogCompactTask)((Either)record.getValue()).right();
            List<Committable> committables = task.doCompact(this.table);
            committables.forEach(committable -> this.output.collect((Object)new StreamRecord(committable)));
        }
    }
}

