/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.CommitterOperator;
import org.apache.paimon.utils.Preconditions;

public class CommitterOperatorFactory<CommitT, GlobalCommitT>
extends AbstractStreamOperatorFactory<CommitT>
implements OneInputStreamOperatorFactory<CommitT, CommitT> {
    protected final boolean streamingCheckpointEnabled;
    protected final boolean forceSingleParallelism;
    protected final String initialCommitUser;
    protected final NavigableMap<Long, GlobalCommitT> committablesPerCheckpoint;
    protected final Committer.Factory<CommitT, GlobalCommitT> committerFactory;
    protected final CommittableStateManager<GlobalCommitT> committableStateManager;
    protected Committer<CommitT, GlobalCommitT> committer;
    protected final Long endInputWatermark;

    public CommitterOperatorFactory(boolean streamingCheckpointEnabled, boolean forceSingleParallelism, String initialCommitUser, Committer.Factory<CommitT, GlobalCommitT> committerFactory, CommittableStateManager<GlobalCommitT> committableStateManager) {
        this(streamingCheckpointEnabled, forceSingleParallelism, initialCommitUser, committerFactory, committableStateManager, null);
    }

    public CommitterOperatorFactory(boolean streamingCheckpointEnabled, boolean forceSingleParallelism, String initialCommitUser, Committer.Factory<CommitT, GlobalCommitT> committerFactory, CommittableStateManager<GlobalCommitT> committableStateManager, Long endInputWatermark) {
        this.streamingCheckpointEnabled = streamingCheckpointEnabled;
        this.forceSingleParallelism = forceSingleParallelism;
        this.initialCommitUser = initialCommitUser;
        this.committablesPerCheckpoint = new TreeMap<Long, GlobalCommitT>();
        this.committerFactory = Preconditions.checkNotNull(committerFactory);
        this.committableStateManager = committableStateManager;
        this.endInputWatermark = endInputWatermark;
    }

    public <T extends StreamOperator<CommitT>> T createStreamOperator(StreamOperatorParameters<CommitT> parameters) {
        return (T)((Object)new CommitterOperator<CommitT, GlobalCommitT>(parameters, this.streamingCheckpointEnabled, this.forceSingleParallelism, this.initialCommitUser, this.committerFactory, this.committableStateManager, this.endInputWatermark));
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CommitterOperator.class;
    }
}

