/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.service.network.messages.MessageBody;
import org.apache.paimon.service.network.messages.MessageDeserializer;
import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBuf;
import org.apache.paimon.utils.SerializationUtils;

public class KvRequest
extends MessageBody {
    private final BinaryRow partition;
    private final int bucket;
    private final BinaryRow[] keys;

    public KvRequest(BinaryRow partition, int bucket, BinaryRow[] keys) {
        this.partition = partition;
        this.bucket = bucket;
        this.keys = keys;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public BinaryRow[] keys() {
        return this.keys;
    }

    @Override
    public byte[] serialize() {
        int size = 0;
        byte[] partitionBytes = SerializationUtils.serializeBinaryRow(this.partition);
        size += 4 + partitionBytes.length;
        size += 4;
        size += 4;
        ArrayList<byte[]> keyBytesList = new ArrayList<byte[]>();
        for (BinaryRow key : this.keys) {
            byte[] keyBytes = SerializationUtils.serializeBinaryRow(key);
            keyBytesList.add(keyBytes);
            size += 4 + keyBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(partitionBytes.length).put(partitionBytes).putInt(this.bucket).putInt(keyBytesList.size());
        for (byte[] keyBytes : keyBytesList) {
            buffer.putInt(keyBytes.length).put(keyBytes);
        }
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvRequest kvRequest = (KvRequest)o;
        return this.bucket == kvRequest.bucket && Objects.equals(this.partition, kvRequest.partition) && Arrays.equals(this.keys, kvRequest.keys);
    }

    public int hashCode() {
        int result = Objects.hash(this.partition, this.bucket);
        result = 31 * result + Arrays.hashCode(this.keys);
        return result;
    }

    public static class KvRequestDeserializer
    implements MessageDeserializer<KvRequest> {
        @Override
        public KvRequest deserializeMessage(ByteBuf buf) {
            BinaryRow partition = SerializationUtils.deserializeBinaryRow(MessageDeserializer.readBytes(buf, buf.readInt()));
            int bucket = buf.readInt();
            int keySize = buf.readInt();
            ArrayList<BinaryRow> keys = new ArrayList<BinaryRow>(keySize);
            for (int i = 0; i < keySize; ++i) {
                keys.add(SerializationUtils.deserializeBinaryRow(MessageDeserializer.readBytes(buf, buf.readInt())));
            }
            return new KvRequest(partition, bucket, keys.toArray(new BinaryRow[0]));
        }
    }
}

