/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.flink.lookup.CompactionDiffFollowUpScanner;
import org.apache.paimon.flink.lookup.LookupFileStoreTable;
import org.apache.paimon.flink.lookup.ReopenException;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataTableStreamScan;
import org.apache.paimon.table.source.TableQueryAuth;
import org.apache.paimon.table.source.snapshot.AllDeltaFollowUpScanner;
import org.apache.paimon.table.source.snapshot.BoundedChecker;
import org.apache.paimon.table.source.snapshot.FollowUpScanner;
import org.apache.paimon.table.source.snapshot.FullStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDataTableScan
extends DataTableStreamScan {
    private static final Logger LOG = LoggerFactory.getLogger(LookupDataTableScan.class);
    private final CoreOptions.StartupMode startupMode;
    private final LookupFileStoreTable.LookupStreamScanMode lookupScanMode;

    public LookupDataTableScan(TableSchema schema, CoreOptions options, SnapshotReader snapshotReader, SnapshotManager snapshotManager, ChangelogManager changelogManager, boolean supportStreamingReadOverwrite, LookupFileStoreTable.LookupStreamScanMode lookupScanMode, TableQueryAuth queryAuth, boolean hasPk) {
        super(schema, options, snapshotReader, snapshotManager, changelogManager, supportStreamingReadOverwrite, queryAuth, hasPk);
        this.startupMode = options.startupMode();
        this.lookupScanMode = lookupScanMode;
        this.dropStats();
        if (options.bucket() == -2) {
            snapshotReader.onlyReadRealBuckets();
        }
    }

    @Override
    @Nullable
    protected SnapshotReader.Plan handleOverwriteSnapshot(Snapshot snapshot) {
        SnapshotReader.Plan plan = super.handleOverwriteSnapshot(snapshot);
        if (plan != null) {
            return plan;
        }
        LOG.info("Dim table found OVERWRITE snapshot {}, reopen.", (Object)snapshot.id());
        throw new ReopenException();
    }

    @Override
    protected StartingScanner createStartingScanner(boolean isStreaming) {
        return this.startupMode != CoreOptions.StartupMode.COMPACTED_FULL ? new FullStartingScanner(this.snapshotReader.snapshotManager()) : super.createStartingScanner(isStreaming);
    }

    @Override
    protected FollowUpScanner createFollowUpScanner() {
        switch (this.lookupScanMode) {
            case CHANGELOG: {
                return super.createFollowUpScanner();
            }
            case FILE_MONITOR: {
                return new AllDeltaFollowUpScanner();
            }
            case COMPACT_DELTA_MONITOR: {
                return new CompactionDiffFollowUpScanner();
            }
        }
        throw new UnsupportedOperationException("Unknown lookup stream scan mode: " + this.lookupScanMode.name());
    }

    @Override
    protected BoundedChecker createBoundedChecker() {
        return BoundedChecker.neverEnd();
    }
}

