/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.BundleFormatWriter;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.AsyncPositionOutputStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.FileWriter;
import org.apache.paimon.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleFileWriter<T, R>
implements FileWriter<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileWriter.class);
    protected final FileIO fileIO;
    protected final Path path;
    private final Function<T, InternalRow> converter;
    private FormatWriter writer;
    private PositionOutputStream out;
    protected long outputBytes;
    private long recordCount;
    protected boolean closed;

    public SingleFileWriter(FileIO fileIO, FormatWriterFactory factory2, Path path, Function<T, InternalRow> converter, String compression, boolean asyncWrite) {
        this.fileIO = fileIO;
        this.path = path;
        this.converter = converter;
        try {
            this.out = fileIO.newOutputStream(path, false);
            if (asyncWrite) {
                this.out = new AsyncPositionOutputStream(this.out);
            }
            this.writer = factory2.create(this.out, compression);
        }
        catch (IOException e) {
            LOG.warn("Failed to open the bulk writer, closing the output stream and throw the error.", (Throwable)e);
            if (this.out != null) {
                this.abort();
            }
            throw new UncheckedIOException(e);
        }
        this.recordCount = 0L;
        this.closed = false;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public void write(T record) throws IOException {
        this.writeImpl(record);
    }

    public void writeBundle(BundleRecords bundle) throws IOException {
        if (this.closed) {
            throw new RuntimeException("Writer has already closed!");
        }
        try {
            if (this.writer instanceof BundleFormatWriter) {
                ((BundleFormatWriter)this.writer).writeBundle(bundle);
            } else {
                for (InternalRow row : bundle) {
                    this.writer.addElement(row);
                }
            }
            this.recordCount += bundle.rowCount();
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + this.path + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    protected InternalRow writeImpl(T record) throws IOException {
        if (this.closed) {
            throw new RuntimeException("Writer has already closed!");
        }
        try {
            InternalRow rowData = this.converter.apply(record);
            this.writer.addElement(rowData);
            ++this.recordCount;
            return rowData;
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + this.path + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        return this.writer.reachTargetSize(suggestedCheck, targetSize);
    }

    @Override
    public void abort() {
        if (this.writer != null) {
            IOUtils.closeQuietly(this.writer);
            this.writer = null;
        }
        if (this.out != null) {
            IOUtils.closeQuietly(this.out);
            this.out = null;
        }
        this.fileIO.deleteQuietly(this.path);
    }

    public AbortExecutor abortExecutor() {
        if (!this.closed) {
            throw new RuntimeException("Writer should be closed!");
        }
        return new AbortExecutor(this.fileIO, this.path);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing file {}", (Object)this.path);
        }
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            if (this.out != null) {
                this.out.flush();
                this.outputBytes = this.out.getPos();
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when closing file {}. Cleaning up.", (Object)this.path, (Object)e);
            this.abort();
            throw e;
        }
        finally {
            this.closed = true;
        }
    }

    public static class AbortExecutor {
        private final FileIO fileIO;
        private final Path path;

        private AbortExecutor(FileIO fileIO, Path path) {
            this.fileIO = fileIO;
            this.path = path;
        }

        public void abort() {
            this.fileIO.deleteQuietly(this.path);
        }
    }
}

