/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ProjectedArray;
import org.apache.paimon.utils.ProjectedRow;

public class SimpleStatsEvolution {
    private final List<String> fieldNames;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castFieldGetters;
    private final Map<List<String>, int[]> indexMappings;
    private final GenericRow emptyValues;
    private final GenericArray emptyNullCounts;

    public SimpleStatsEvolution(RowType rowType, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castFieldGetters) {
        this.fieldNames = rowType.getFieldNames();
        this.indexMapping = indexMapping;
        this.castFieldGetters = castFieldGetters;
        this.indexMappings = new ConcurrentHashMap<List<String>, int[]>();
        this.emptyValues = new GenericRow(this.fieldNames.size());
        this.emptyNullCounts = new GenericArray(new Object[this.fieldNames.size()]);
    }

    public InternalRow evolution(InternalRow row, @Nullable List<String> denseFields) {
        InternalRow result = row;
        if (denseFields != null && denseFields.isEmpty()) {
            result = this.emptyValues;
        } else if (denseFields != null) {
            int[] denseIndexMapping = this.indexMappings.computeIfAbsent(denseFields, k -> this.fieldNames.stream().mapToInt(denseFields::indexOf).toArray());
            result = ProjectedRow.from(denseIndexMapping).replaceRow(result);
        }
        if (this.indexMapping != null) {
            result = ProjectedRow.from(this.indexMapping).replaceRow(result);
        }
        if (this.castFieldGetters != null) {
            result = CastedRow.from(this.castFieldGetters).replaceRow(result);
        }
        return result;
    }

    public Result evolution(SimpleStats stats, @Nullable Long rowCount, @Nullable List<String> denseFields) {
        InternalRow minValues = stats.minValues();
        InternalRow maxValues = stats.maxValues();
        InternalArray nullCounts = stats.nullCounts();
        if (denseFields != null && denseFields.isEmpty()) {
            minValues = this.emptyValues;
            maxValues = this.emptyValues;
            nullCounts = this.emptyNullCounts;
        } else if (denseFields != null) {
            int[] denseIndexMapping = this.indexMappings.computeIfAbsent(denseFields, k -> this.fieldNames.stream().mapToInt(denseFields::indexOf).toArray());
            minValues = ProjectedRow.from(denseIndexMapping).replaceRow(minValues);
            maxValues = ProjectedRow.from(denseIndexMapping).replaceRow(maxValues);
            nullCounts = ProjectedArray.from(denseIndexMapping).replaceArray(nullCounts);
        }
        if (this.indexMapping != null) {
            minValues = ProjectedRow.from(this.indexMapping).replaceRow(minValues);
            maxValues = ProjectedRow.from(this.indexMapping).replaceRow(maxValues);
            if (rowCount == null) {
                throw new RuntimeException("Schema Evolution for stats needs row count.");
            }
            nullCounts = new NullCountsEvoArray(this.indexMapping, nullCounts, rowCount);
        }
        if (this.castFieldGetters != null) {
            minValues = CastedRow.from(this.castFieldGetters).replaceRow(minValues);
            maxValues = CastedRow.from(this.castFieldGetters).replaceRow(maxValues);
        }
        return new Result(minValues, maxValues, nullCounts);
    }

    private static class NullCountsEvoArray
    implements InternalArray {
        private final int[] indexMapping;
        private final InternalArray array;
        private final long notFoundValue;

        private NullCountsEvoArray(int[] indexMapping, InternalArray array, long notFoundValue) {
            this.indexMapping = indexMapping;
            this.array = array;
            this.notFoundValue = notFoundValue;
        }

        @Override
        public int size() {
            return this.indexMapping.length;
        }

        @Override
        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return this.array.isNullAt(this.indexMapping[pos]);
        }

        @Override
        public long getLong(int pos) {
            if (this.indexMapping[pos] < 0) {
                return this.notFoundValue;
            }
            return this.array.getLong(this.indexMapping[pos]);
        }

        @Override
        public boolean getBoolean(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getShort(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloat(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDouble(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BinaryString getString(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Decimal getDecimal(int pos, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Timestamp getTimestamp(int pos, int precision) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBinary(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Variant getVariant(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalArray getArray(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalMap getMap(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalRow getRow(int pos, int numFields) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean[] toBooleanArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] toByteArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short[] toShortArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] toIntArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long[] toLongArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] toFloatArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] toDoubleArray() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Result {
        private final InternalRow minValues;
        private final InternalRow maxValues;
        private final InternalArray nullCounts;

        public Result(InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            this.minValues = minValues;
            this.maxValues = maxValues;
            this.nullCounts = nullCounts;
        }

        public InternalRow minValues() {
            return this.minValues;
        }

        public InternalRow maxValues() {
            return this.maxValues;
        }

        public InternalArray nullCounts() {
            return this.nullCounts;
        }
    }
}

