/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.paimon.AppendOnlyFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.operation.AppendOnlyFileStoreScan;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.AbstractDataTableRead;
import org.apache.paimon.table.source.AppendOnlySplitGenerator;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class AppendOnlyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient AppendOnlyFileStore lazyStore;

    AppendOnlyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema) {
        this(fileIO, path, tableSchema, CatalogEnvironment.empty());
    }

    public AppendOnlyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        super(fileIO, path, tableSchema, catalogEnvironment);
    }

    public AppendOnlyFileStore store() {
        if (this.lazyStore == null) {
            this.lazyStore = new AppendOnlyFileStore(this.fileIO, this.schemaManager(), this.tableSchema, new CoreOptions(this.tableSchema.options()), this.tableSchema.logicalPartitionType(), this.tableSchema.logicalBucketKeyType(), this.tableSchema.logicalRowType().notNull(), this.name(), this.catalogEnvironment);
        }
        return this.lazyStore;
    }

    @Override
    protected SplitGenerator splitGenerator() {
        return new AppendOnlySplitGenerator(this.store().options().splitTargetSize(), this.store().options().splitOpenFileCost(), this.bucketMode());
    }

    @Override
    public boolean supportStreamingReadOverwrite() {
        return new CoreOptions(this.tableSchema.options()).streamingReadAppendOverwrite();
    }

    @Override
    protected BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer() {
        return (scan, predicate) -> ((AppendOnlyFileStoreScan)scan).withFilter((Predicate)predicate);
    }

    @Override
    public InnerTableRead newRead() {
        final RawFileSplitRead read = this.store().newRead();
        return new AbstractDataTableRead(this.schema()){

            @Override
            protected InnerTableRead innerWithFilter(Predicate predicate) {
                read.withFilter(predicate);
                return this;
            }

            @Override
            public void applyReadType(RowType readType) {
                read.withReadType(readType);
            }

            @Override
            public RecordReader<InternalRow> reader(Split split) throws IOException {
                return read.createReader((DataSplit)split);
            }
        };
    }

    @Override
    public TableWriteImpl<InternalRow> newWrite(String commitUser) {
        return this.newWrite(commitUser, null, null);
    }

    public TableWriteImpl<InternalRow> newWrite(String commitUser, @Nullable ManifestCacheFilter manifestFilter, @Nullable Integer writeId) {
        BaseAppendFileStoreWrite writer = this.store().newWrite(commitUser, manifestFilter, writeId);
        return new TableWriteImpl<InternalRow>(this.rowType(), writer, this.createRowKeyExtractor(), (record, rowKind) -> {
            Preconditions.checkState(rowKind.isAdd(), "Append only writer can not accept row with RowKind %s", new Object[]{rowKind});
            return record.row();
        }, this.rowKindGenerator(), CoreOptions.fromMap(this.tableSchema.options()).ignoreDelete());
    }

    @Override
    public LocalTableQuery newLocalTableQuery() {
        throw new UnsupportedOperationException();
    }
}

