/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingContext;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.table.source.snapshot.TimeTravelUtil;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousFromTimestampStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousFromTimestampStartingScanner.class);
    private final ChangelogManager changelogManager;
    private final long startupMillis;
    private final boolean startFromChangelog;

    public ContinuousFromTimestampStartingScanner(SnapshotManager snapshotManager, ChangelogManager changelogManager, long startupMillis, boolean changelogDecoupled) {
        super(snapshotManager);
        this.changelogManager = changelogManager;
        this.startupMillis = startupMillis;
        this.startFromChangelog = changelogDecoupled;
        this.startingSnapshotId = TimeTravelUtil.earlierThanTimeMills(snapshotManager, changelogManager, startupMillis, this.startFromChangelog, false);
    }

    @Override
    public StartingContext startingContext() {
        if (this.startingSnapshotId == null) {
            return StartingContext.EMPTY;
        }
        return new StartingContext(this.startingSnapshotId + 1L, false);
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        if (this.startingSnapshotId == null) {
            this.startingSnapshotId = TimeTravelUtil.earlierThanTimeMills(this.snapshotManager, this.changelogManager, this.startupMillis, this.startFromChangelog, false);
        }
        if (this.startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        return new StartingScanner.NextSnapshot(this.startingSnapshotId + 1L);
    }
}

