/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexPathFactory;

public class DeletionFileWriter
implements Closeable {
    private final Path path;
    private final boolean isExternalPath;
    private final DataOutputStream out;
    private final LinkedHashMap<String, DeletionVectorMeta> dvMetas;

    public DeletionFileWriter(IndexPathFactory pathFactory, FileIO fileIO) throws IOException {
        this.path = pathFactory.newPath();
        this.isExternalPath = pathFactory.isExternalPath();
        this.out = new DataOutputStream(fileIO.newOutputStream(this.path, true));
        this.out.writeByte(1);
        this.dvMetas = new LinkedHashMap();
    }

    public long getPos() {
        return this.out.size();
    }

    public void write(String key, DeletionVector deletionVector) throws IOException {
        int start = this.out.size();
        int length = deletionVector.serializeTo(this.out);
        this.dvMetas.put(key, new DeletionVectorMeta(key, start, length, deletionVector.getCardinality()));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public IndexFileMeta result() {
        return new IndexFileMeta("DELETION_VECTORS", this.path.getName(), this.getPos(), this.dvMetas.size(), this.dvMetas, this.isExternalPath ? this.path.toString() : null);
    }
}

