/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.variant.Variant;

public class NestedProjectedRowData
implements RowData,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RowType producedDataType;
    private final int[][] projectedFields;
    private final int[] lastProjectedFields;
    private final Object[] cachedFields;
    private final boolean[] isFieldsCached;
    private final boolean[] cachedNullAt;
    private final boolean[] isNullAtCached;
    private transient RowData row;

    NestedProjectedRowData(RowType producedDataType, int[][] projectedFields) {
        this.producedDataType = producedDataType;
        this.projectedFields = projectedFields;
        this.lastProjectedFields = new int[projectedFields.length];
        for (int i = 0; i < projectedFields.length; ++i) {
            this.lastProjectedFields[i] = projectedFields[i][projectedFields[i].length - 1];
        }
        this.cachedFields = new Object[projectedFields.length];
        this.isFieldsCached = new boolean[projectedFields.length];
        this.cachedNullAt = new boolean[projectedFields.length];
        this.isNullAtCached = new boolean[projectedFields.length];
    }

    public NestedProjectedRowData replaceRow(RowData row) {
        this.row = row;
        Arrays.fill(this.isFieldsCached, false);
        Arrays.fill(this.isNullAtCached, false);
        return this;
    }

    @Nullable
    public static NestedProjectedRowData copy(@Nullable NestedProjectedRowData rowData) {
        if (rowData == null) {
            return null;
        }
        return new NestedProjectedRowData(rowData.producedDataType, rowData.projectedFields);
    }

    @Override
    public int getArity() {
        return this.projectedFields.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind rowKind) {
        this.row.setRowKind(rowKind);
    }

    @Override
    public boolean isNullAt(int pos) {
        if (this.isNullAtCached[pos]) {
            return this.cachedNullAt[pos];
        }
        RowData rowData = this.extractInternalRow(pos);
        boolean result = rowData == null ? true : rowData.isNullAt(this.lastProjectedFields[pos]);
        this.isNullAtCached[pos] = true;
        this.cachedNullAt[pos] = result;
        return result;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.getFieldAs(pos, RowData::getBoolean);
    }

    @Override
    public byte getByte(int pos) {
        return this.getFieldAs(pos, RowData::getByte);
    }

    @Override
    public short getShort(int pos) {
        return this.getFieldAs(pos, RowData::getShort);
    }

    @Override
    public int getInt(int pos) {
        return this.getFieldAs(pos, RowData::getInt);
    }

    @Override
    public long getLong(int pos) {
        return this.getFieldAs(pos, RowData::getLong);
    }

    @Override
    public float getFloat(int pos) {
        return this.getFieldAs(pos, RowData::getFloat).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return this.getFieldAs(pos, RowData::getDouble);
    }

    @Override
    public StringData getString(int pos) {
        return this.getFieldAs(pos, RowData::getString);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.getFieldAs(pos, (rowData, internalPos) -> rowData.getDecimal((int)internalPos, precision, scale));
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return this.getFieldAs(pos, (rowData, internalPos) -> rowData.getTimestamp((int)internalPos, precision));
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return this.getFieldAs(pos, RowData::getRawValue);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.getFieldAs(pos, RowData::getBinary);
    }

    @Override
    public ArrayData getArray(int pos) {
        return this.getFieldAs(pos, RowData::getArray);
    }

    @Override
    public MapData getMap(int pos) {
        return this.getFieldAs(pos, RowData::getMap);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return this.getFieldAs(pos, (rowData, internalPos) -> rowData.getRow((int)internalPos, numFields));
    }

    @Override
    public Variant getVariant(int pos) {
        return this.getFieldAs(pos, RowData::getVariant);
    }

    @Nullable
    private RowData extractInternalRow(int pos) {
        int[] projectedField = this.projectedFields[pos];
        RowData rowData = this.row;
        RowType dataType = this.producedDataType;
        for (int i = 0; i < projectedField.length - 1; ++i) {
            dataType = (RowType)dataType.getTypeAt(projectedField[i]);
            if (rowData.isNullAt(projectedField[i])) {
                return null;
            }
            rowData = rowData.getRow(projectedField[i], dataType.getFieldCount());
        }
        return rowData;
    }

    private <T> T getFieldAs(int pos, BiFunction<RowData, Integer, T> getter) {
        T result;
        if (this.isFieldsCached[pos]) {
            return (T)this.cachedFields[pos];
        }
        RowData rowData = this.extractInternalRow(pos);
        if (rowData == null) {
            this.isNullAtCached[pos] = true;
            this.cachedNullAt[pos] = true;
            this.isFieldsCached[pos] = true;
            this.cachedFields[pos] = null;
            result = null;
        } else {
            result = getter.apply(rowData, this.lastProjectedFields[pos]);
            this.isNullAtCached[pos] = true;
            this.cachedNullAt[pos] = result == null;
            this.isFieldsCached[pos] = true;
            this.cachedFields[pos] = result;
        }
        return result;
    }

    @VisibleForTesting
    public int[][] getProjectedFields() {
        return this.projectedFields;
    }

    @VisibleForTesting
    public RowType getRowType() {
        return this.producedDataType;
    }
}

