/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.Expression;
import org.apache.paimon.flink.action.cdc.utils.DfsSort;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;

public class ComputedColumnUtils {
    public static List<ComputedColumn> buildComputedColumns(List<String> computedColumnArgs, List<DataField> physicFields) {
        return ComputedColumnUtils.buildComputedColumns(computedColumnArgs, physicFields, true);
    }

    public static List<ComputedColumn> buildComputedColumns(List<String> computedColumnArgs, List<DataField> physicFields, boolean caseSensitive) {
        Map<String, DataType> typeMapping = physicFields.stream().collect(Collectors.toMap(DataField::name, DataField::type, (v1, v2) -> v2));
        LinkedHashMap<String, Tuple2<String, String[]>> sortedArgs = ComputedColumnUtils.sortComputedColumnArgs(computedColumnArgs, caseSensitive);
        ArrayList<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
        for (Map.Entry<String, Tuple2<String, String[]>> columnArg : sortedArgs.entrySet()) {
            String columnName = columnArg.getKey().trim();
            String exprName = ((String)columnArg.getValue().f0).trim();
            String[] args = (String[])columnArg.getValue().f1;
            Expression expr = Expression.create(typeMapping, caseSensitive, exprName, args);
            ComputedColumn cmpColumn = new ComputedColumn(columnName, expr);
            computedColumns.add(new ComputedColumn(columnName, expr));
            typeMapping.put(columnName, cmpColumn.columnType());
        }
        return computedColumns;
    }

    private static LinkedHashMap<String, Tuple2<String, String[]>> sortComputedColumnArgs(List<String> computedColumnArgs, boolean caseSensitive) {
        List argList = computedColumnArgs.stream().map(x -> caseSensitive ? x : x.toUpperCase()).collect(Collectors.toList());
        LinkedHashMap<String, Tuple2> eqMap = new LinkedHashMap<String, Tuple2>();
        LinkedHashMap<String, String> refMap = new LinkedHashMap<String, String>();
        for (String arg : argList) {
            String[] kv = arg.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid computed column argument: %s. Please use format 'column-name=expr-name(args, ...)'.", arg));
            }
            String expression = kv[1].trim();
            int left = expression.indexOf(40);
            int right = expression.indexOf(41);
            Preconditions.checkArgument(left > 0 && right > left, String.format("Invalid expression: %s. Please use format 'expr-name(args, ...)'.", expression));
            String exprName = expression.substring(0, left);
            String[] args = expression.substring(left + 1, right).split(",");
            eqMap.put(kv[0].trim(), Tuple2.of((Object)exprName, (Object)args));
            refMap.put(kv[0].trim(), args[0].trim());
        }
        List<String> sortedKeys = DfsSort.sortKeys(refMap);
        LinkedHashMap<String, Tuple2<String, String[]>> sortedMap = new LinkedHashMap<String, Tuple2<String, String[]>>(refMap.size());
        for (String key : sortedKeys) {
            sortedMap.put(key, (Tuple2<String, String[]>)eqMap.get(key));
        }
        return sortedMap;
    }
}

