/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DfsSort {
    public static <K> LinkedHashMap<K, K> sort(LinkedHashMap<K, K> depMap) {
        List<K> sortedKeys = DfsSort.sortKeys(depMap);
        LinkedHashMap<K, K> sortedMap = new LinkedHashMap<K, K>();
        for (K key : sortedKeys) {
            sortedMap.put(key, depMap.get(key));
        }
        return sortedMap;
    }

    public static <K> List<K> sortKeys(LinkedHashMap<K, K> depMap) {
        LinkedHashMap<Object, Set> revMap = new LinkedHashMap<Object, Set>();
        ArrayList<K> noDeps = new ArrayList<K>();
        for (Map.Entry<K, K> entry : depMap.entrySet()) {
            K key = entry.getKey();
            K val = entry.getValue();
            if (val == null || !depMap.containsKey(val)) {
                noDeps.add(key);
                continue;
            }
            revMap.computeIfAbsent(val, k -> new HashSet()).add(key);
        }
        ArrayList<K> sorted = new ArrayList<K>();
        HashSet visited = new HashSet();
        HashSet tempMark = new HashSet();
        for (Map.Entry<K, K> entry : depMap.entrySet()) {
            K key = entry.getKey();
            K val = entry.getValue();
            if (val == null || !depMap.containsKey(val) || visited.contains(key)) continue;
            DfsSort.dfs(key, revMap, sorted, visited, tempMark);
        }
        Collections.reverse(noDeps);
        sorted.addAll(noDeps);
        Collections.reverse(sorted);
        return sorted;
    }

    private static <K> void dfs(K node, Map<K, Set<K>> revMap, List<K> sorted, Set<K> visited, Set<K> tempMark) {
        if (tempMark.contains(node)) {
            throw new IllegalArgumentException("Cycle detected: " + node);
        }
        if (visited.contains(node)) {
            return;
        }
        tempMark.add(node);
        for (Object dependent : revMap.getOrDefault(node, Collections.emptySet())) {
            DfsSort.dfs(dependent, revMap, sorted, visited, tempMark);
        }
        tempMark.remove(node);
        visited.add(node);
        sorted.add(node);
    }
}

