/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.shade.org.apache.commons.lang3.StringUtils;
import org.apache.paimon.table.Table;

public class CreateBranchProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "create_branch";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="branch", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="tag", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String branchName, String tagName) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        if (!StringUtils.isBlank(tagName)) {
            table.createBranch(branchName, tagName);
        } else {
            table.createBranch(branchName);
        }
        return new String[]{"Success"};
    }
}

