/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.FlinkWriteSink;
import org.apache.paimon.flink.sink.LogSinkFunction;
import org.apache.paimon.flink.sink.RowDataStoreWriteOperator;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;

public class FixedBucketSink
extends FlinkWriteSink<InternalRow> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final LogSinkFunction logSinkFunction;

    public FixedBucketSink(FileStoreTable table, @Nullable Map<String, String> overwritePartition, @Nullable LogSinkFunction logSinkFunction) {
        super(table, overwritePartition);
        this.logSinkFunction = logSinkFunction;
    }

    @Override
    protected OneInputStreamOperatorFactory<InternalRow, Committable> createWriteOperatorFactory(StoreSinkWrite.Provider writeProvider, String commitUser) {
        Options options = this.table.coreOptions().toConfiguration();
        boolean coordinatorEnabled = options.get(FlinkConnectorOptions.SINK_WRITER_COORDINATOR_ENABLED);
        return coordinatorEnabled ? new RowDataStoreWriteOperator.CoordinatedFactory(this.table, this.logSinkFunction, writeProvider, commitUser) : new RowDataStoreWriteOperator.Factory(this.table, this.logSinkFunction, writeProvider, commitUser);
    }
}

