/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.crosspartition.IndexBootstrap;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.DynamicBucketRowWriteOperator;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.flink.sink.FlinkWriteSink;
import org.apache.paimon.flink.sink.RowWithBucketChannelComputer;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.index.GlobalIndexAssignerOperator;
import org.apache.paimon.flink.sink.index.IndexBootstrapOperator;
import org.apache.paimon.flink.sink.index.KeyPartRowChannelComputer;
import org.apache.paimon.flink.sink.index.KeyWithRowSerializer;
import org.apache.paimon.flink.utils.InternalRowTypeSerializer;
import org.apache.paimon.flink.utils.InternalTypeInfo;
import org.apache.paimon.flink.utils.ManagedMemoryUtils;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.MathUtils;

public class GlobalDynamicBucketSink
extends FlinkWriteSink<Tuple2<InternalRow, Integer>> {
    private static final long serialVersionUID = 1L;

    public GlobalDynamicBucketSink(FileStoreTable table, @Nullable Map<String, String> overwritePartition) {
        super(table, overwritePartition);
    }

    @Override
    protected OneInputStreamOperatorFactory<Tuple2<InternalRow, Integer>, Committable> createWriteOperatorFactory(StoreSinkWrite.Provider writeProvider, String commitUser) {
        Options options = this.table.coreOptions().toConfiguration();
        boolean coordinatorEnabled = options.get(FlinkConnectorOptions.SINK_WRITER_COORDINATOR_ENABLED);
        return coordinatorEnabled ? new DynamicBucketRowWriteOperator.CoordinatedFactory(this.table, writeProvider, commitUser) : new DynamicBucketRowWriteOperator.Factory(this.table, writeProvider, commitUser);
    }

    public DataStreamSink<?> build(DataStream<InternalRow> input, @Nullable Integer parallelism) {
        TableSchema schema = this.table.schema();
        CoreOptions options = this.table.coreOptions();
        RowType rowType = schema.logicalRowType();
        List<String> primaryKeys = schema.primaryKeys();
        InternalRowTypeSerializer rowSerializer = new InternalRowTypeSerializer(rowType);
        RowType bootstrapType = IndexBootstrap.bootstrapType(schema);
        InternalRowTypeSerializer bootstrapSerializer = new InternalRowTypeSerializer(bootstrapType);
        SingleOutputStreamOperator bootstraped = input.transform("INDEX_BOOTSTRAP", new InternalTypeInfo<InternalRow>(new KeyWithRowSerializer<InternalRow>(bootstrapSerializer, rowSerializer)), new IndexBootstrapOperator.Factory(new IndexBootstrap(this.table), r -> r)).setParallelism(input.getParallelism());
        Integer assignerParallelism = MathUtils.max(options.dynamicBucketInitialBuckets(), options.dynamicBucketAssignerParallelism());
        if (assignerParallelism == null) {
            assignerParallelism = parallelism;
        }
        KeyPartRowChannelComputer channelComputer = new KeyPartRowChannelComputer(rowType, bootstrapType, primaryKeys);
        DataStream<Tuple2<KeyPartOrRow, InternalRow>> partitionByKeyHash = FlinkStreamPartitioner.partition(bootstraped, channelComputer, assignerParallelism);
        TupleTypeInfo rowWithBucketType = new TupleTypeInfo(new TypeInformation[]{input.getType(), BasicTypeInfo.INT_TYPE_INFO});
        SingleOutputStreamOperator bucketAssigned = partitionByKeyHash.transform("cross-partition-bucket-assigner", (TypeInformation)rowWithBucketType, (OneInputStreamOperator)GlobalIndexAssignerOperator.forRowData(this.table)).setParallelism(partitionByKeyHash.getParallelism());
        ManagedMemoryUtils.declareManagedMemory(bucketAssigned, options.toConfiguration().get(FlinkConnectorOptions.SINK_CROSS_PARTITION_MANAGED_MEMORY));
        DataStream<Tuple2<InternalRow, Integer>> partitionByBucket = FlinkStreamPartitioner.partition(bucketAssigned, new RowWithBucketChannelComputer(schema), parallelism);
        return this.sinkFrom(partitionByBucket, CoreOptions.createCommitUser(options.toConfiguration()));
    }
}

