/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.paimon.append.MultiTableAppendCompactTask;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.flink.compact.MultiAppendCompactTableScan;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.flink.sink.MultiTableCompactionTaskTypeInfo;
import org.apache.paimon.flink.source.AbstractNonCoordinatedSourceReader;
import org.apache.paimon.flink.source.SimpleSourceSplit;
import org.apache.paimon.flink.source.operator.CombinedCompactorSource;

public class CombinedAppendCompactStreamSource
extends CombinedCompactorSource<MultiTableAppendCompactTask> {
    private final long monitorInterval;
    private final Map<String, String> tableOptions;

    public CombinedAppendCompactStreamSource(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, Map<String, String> tableOptions, long monitorInterval) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, true);
        this.tableOptions = tableOptions;
        this.monitorInterval = monitorInterval;
    }

    public SourceReader<MultiTableAppendCompactTask, SimpleSourceSplit> createReader(SourceReaderContext sourceReaderContext) throws Exception {
        return new Reader();
    }

    public static DataStream<MultiTableAppendCompactTask> buildSource(StreamExecutionEnvironment env, String name, CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, Map<String, String> tableOptions, long monitorInterval) {
        CombinedAppendCompactStreamSource source = new CombinedAppendCompactStreamSource(catalogLoader, includingPattern, excludingPattern, databasePattern, tableOptions, monitorInterval);
        MultiTableCompactionTaskTypeInfo compactionTaskTypeInfo = new MultiTableCompactionTaskTypeInfo();
        return env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), name, (TypeInformation)compactionTaskTypeInfo).forceNonParallel();
    }

    private class Reader
    extends AbstractNonCoordinatedSourceReader<MultiTableAppendCompactTask> {
        private MultiTableScanBase<MultiTableAppendCompactTask> tableScan;

        private Reader() {
        }

        @Override
        public void start() {
            super.start();
            this.tableScan = new MultiAppendCompactTableScan(CombinedAppendCompactStreamSource.this.catalogLoader, CombinedAppendCompactStreamSource.this.includingPattern, CombinedAppendCompactStreamSource.this.excludingPattern, CombinedAppendCompactStreamSource.this.databasePattern, CombinedAppendCompactStreamSource.this.isStreaming, CombinedAppendCompactStreamSource.this.tableOptions);
        }

        public InputStatus pollNext(ReaderOutput<MultiTableAppendCompactTask> readerOutput) throws Exception {
            MultiTableScanBase.ScanResult scanResult = this.tableScan.scanTable(readerOutput);
            if (scanResult == MultiTableScanBase.ScanResult.FINISHED) {
                return InputStatus.END_OF_INPUT;
            }
            if (scanResult == MultiTableScanBase.ScanResult.IS_EMPTY) {
                Thread.sleep(CombinedAppendCompactStreamSource.this.monitorInterval);
            }
            return InputStatus.MORE_AVAILABLE;
        }

        @Override
        public void close() throws Exception {
            super.close();
            if (this.tableScan != null) {
                this.tableScan.close();
            }
        }
    }
}

