/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Arrays;
import java.util.List;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.PojoManifestEntry;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.SerializationUtils;

@Public
public interface ManifestEntry
extends FileEntry {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_KIND", new TinyIntType(false)), new DataField(1, "_PARTITION", SerializationUtils.newBytesType(false)), new DataField(2, "_BUCKET", new IntType(false)), new DataField(3, "_TOTAL_BUCKETS", new IntType(false)), new DataField(4, "_FILE", DataFileMeta.SCHEMA)));

    public static ManifestEntry create(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, DataFileMeta file) {
        return new PojoManifestEntry(kind, partition, bucket, totalBuckets, file);
    }

    public DataFileMeta file();

    public ManifestEntry copyWithoutStats();

    public ManifestEntry assignSequenceNumber(long var1, long var3);

    public ManifestEntry assignFirstRowId(long var1);

    public static long recordCount(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public static long recordCountAdd(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().filter(manifestEntry -> FileKind.ADD.equals((Object)manifestEntry.kind())).mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public static long recordCountDelete(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().filter(manifestEntry -> FileKind.DELETE.equals((Object)manifestEntry.kind())).mapToLong(manifest -> manifest.file().rowCount()).sum();
    }
}

