/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.rest.DefaultErrorHandler;
import org.apache.paimon.rest.ErrorHandler;
import org.apache.paimon.rest.HttpClientUtils;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.RESTClient;
import org.apache.paimon.rest.RESTRequest;
import org.apache.paimon.rest.RESTResponse;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.auth.RESTAuthFunction;
import org.apache.paimon.rest.auth.RESTAuthParameter;
import org.apache.paimon.rest.exceptions.RESTException;
import org.apache.paimon.rest.responses.ErrorResponse;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpDelete;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpGet;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpPost;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.paimon.shade.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.paimon.shade.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.paimon.shade.hc.core5.http.Header;
import org.apache.paimon.shade.hc.core5.http.ParseException;
import org.apache.paimon.shade.hc.core5.http.io.entity.StringEntity;
import org.apache.paimon.shade.hc.core5.http.message.BasicHeader;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.utils.StringUtils;

public class HttpClient
implements RESTClient {
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientUtils.createLoggingBuilder().build();
    private final String uri;
    private ErrorHandler errorHandler;

    public HttpClient(String uri) {
        this.uri = this.normalizeUri(uri);
        this.errorHandler = DefaultErrorHandler.getInstance();
    }

    @Override
    public <T extends RESTResponse> T get(String path, Class<T> responseType, RESTAuthFunction restAuthFunction) {
        Header[] authHeaders = HttpClient.getHeaders(path, "GET", "", restAuthFunction);
        HttpGet httpGet = new HttpGet(this.getRequestUrl(path, null));
        httpGet.setHeaders(authHeaders);
        return this.exec(httpGet, responseType);
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, RESTAuthFunction restAuthFunction) {
        Header[] authHeaders = HttpClient.getHeaders(path, queryParams, "GET", "", restAuthFunction);
        HttpGet httpGet = new HttpGet(this.getRequestUrl(path, queryParams));
        httpGet.setHeaders(authHeaders);
        return this.exec(httpGet, responseType);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, RESTAuthFunction restAuthFunction) {
        return this.post(path, body, null, restAuthFunction);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, RESTAuthFunction restAuthFunction) {
        try {
            String bodyStr = RESTApi.toJson(body);
            Header[] authHeaders = HttpClient.getHeaders(path, "POST", bodyStr, restAuthFunction);
            HttpPost httpPost = new HttpPost(this.getRequestUrl(path, null));
            httpPost.setHeaders(authHeaders);
            String encodedBody = RESTUtil.encodedBody(body);
            if (encodedBody != null) {
                httpPost.setEntity(new StringEntity(encodedBody));
            }
            return this.exec(httpPost, responseType);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "build post request failed.", new Object[0]);
        }
    }

    @Override
    public <T extends RESTResponse> T delete(String path, RESTAuthFunction restAuthFunction) {
        return this.delete(path, null, restAuthFunction);
    }

    @Override
    public <T extends RESTResponse> T delete(String path, RESTRequest body, RESTAuthFunction restAuthFunction) {
        try {
            String bodyStr = RESTApi.toJson(body);
            Header[] authHeaders = HttpClient.getHeaders(path, "DELETE", bodyStr, restAuthFunction);
            HttpDelete httpDelete = new HttpDelete(this.getRequestUrl(path, null));
            httpDelete.setHeaders(authHeaders);
            String encodedBody = RESTUtil.encodedBody(body);
            if (encodedBody != null) {
                httpDelete.setEntity(new StringEntity(encodedBody));
            }
            return this.exec(httpDelete, null);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "build delete request failed.", new Object[0]);
        }
    }

    @VisibleForTesting
    void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends RESTResponse> T exec(HttpUriRequestBase request, Class<T> responseType) {
        try (CloseableHttpResponse response = HTTP_CLIENT.execute(request);){
            RESTResponse rESTResponse;
            String responseBodyStr = RESTUtil.extractResponseBodyAsString(response);
            if (!RESTUtil.isSuccessful(response)) {
                ErrorResponse error;
                try {
                    error = RESTApi.fromJson(responseBodyStr, ErrorResponse.class);
                }
                catch (JsonProcessingException e) {
                    error = new ErrorResponse(null, null, responseBodyStr != null ? responseBodyStr : "response body is null", response.getCode());
                }
                this.errorHandler.accept(error, HttpClient.getRequestId(response));
            }
            if (responseType != null && responseBodyStr != null) {
                rESTResponse = (RESTResponse)RESTApi.fromJson(responseBodyStr, responseType);
                return (T)rESTResponse;
            }
            if (responseType == null) {
                rESTResponse = null;
                return (T)rESTResponse;
            }
            throw new RESTException("response body is null.", new Object[0]);
        }
        catch (IOException | ParseException e) {
            throw new RESTException(e, "Error occurred while processing %s request", request.getMethod());
        }
    }

    private String normalizeUri(String rawUri) {
        String normalized;
        if (StringUtils.isEmpty(rawUri)) {
            throw new IllegalArgumentException("uri is empty which must be defined.");
        }
        String string = normalized = rawUri.endsWith("/") ? rawUri.substring(0, rawUri.length() - 1) : rawUri;
        if (!normalized.startsWith("http://") && !normalized.startsWith("https://")) {
            normalized = String.format("http://%s", normalized);
        }
        return normalized;
    }

    @VisibleForTesting
    protected String getRequestUrl(String path, Map<String, String> queryParams) {
        String fullPath = StringUtils.isNullOrWhitespaceOnly(path) ? this.uri : this.uri + path;
        return RESTUtil.buildRequestUrl(fullPath, queryParams);
    }

    @VisibleForTesting
    public String uri() {
        return this.uri;
    }

    private static String getRequestId(CloseableHttpResponse response) {
        Header header = response.getFirstHeader("x-request-id");
        return header != null ? header.getValue() : "unknown";
    }

    private static Header[] getHeaders(String path, String method, String data, Function<RESTAuthParameter, Map<String, String>> headerFunction) {
        return HttpClient.getHeaders(path, Collections.emptyMap(), method, data, headerFunction);
    }

    private static Header[] getHeaders(String path, Map<String, String> queryParams, String method, String data, Function<RESTAuthParameter, Map<String, String>> headerFunction) {
        if (headerFunction == null) {
            return new Header[0];
        }
        RESTAuthParameter restAuthParameter = new RESTAuthParameter(path, queryParams, method, data);
        Map<String, String> headers = headerFunction.apply(restAuthParameter);
        return (Header[])headers.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), entry.getValue())).toArray(Header[]::new);
    }
}

