/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.object;

import java.util.Map;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.object.ObjectTableImpl;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public interface ObjectTable
extends Table {
    public static final RowType SCHEMA = RowType.builder().field("path", DataTypes.STRING().notNull(), "Relative path of object").field("name", DataTypes.STRING().notNull(), "Name of object").field("length", DataTypes.BIGINT().notNull(), "Bytes length of object").field("mtime", DataTypes.BIGINT().notNull(), "Modification time of object").field("atime", DataTypes.BIGINT().notNull(), "Access time of object").field("owner", DataTypes.STRING().nullable(), "Owner of object").build().notNull();

    public String location();

    @Override
    public ObjectTable copy(Map<String, String> var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Identifier identifier;
        private FileIO fileIO;
        private String location;
        private String comment;

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder fileIO(FileIO fileIO) {
            this.fileIO = fileIO;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ObjectTable build() {
            return new ObjectTableImpl(this.identifier, this.fileIO, this.location, this.comment);
        }
    }
}

