/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.predicate.CompareUtils;
import org.apache.paimon.predicate.SortValue;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.PushDownUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;

public class TopNDataSplitEvaluator {
    private final Map<Long, TableSchema> tableSchemas = new HashMap<Long, TableSchema>();
    private final TableSchema schema;
    private final SchemaManager schemaManager;

    public TopNDataSplitEvaluator(TableSchema schema, SchemaManager schemaManager) {
        this.schema = schema;
        this.schemaManager = schemaManager;
    }

    public List<DataSplit> evaluate(SortValue order, int limit, List<DataSplit> splits) {
        if (limit > splits.size()) {
            return splits;
        }
        return this.getTopNSplits(order, limit, splits);
    }

    private List<DataSplit> getTopNSplits(SortValue order, int limit, List<DataSplit> splits) {
        int index = order.field().index();
        DataField field = this.schema.fields().get(index);
        SimpleStatsEvolutions evolutions = new SimpleStatsEvolutions(id -> this.scanTableSchema((long)id).fields(), this.schema.id());
        ArrayList<DataSplit> results = new ArrayList<DataSplit>();
        ArrayList<RichSplit> richSplits = new ArrayList<RichSplit>();
        for (DataSplit split : splits) {
            if (!PushDownUtils.minmaxAvailable(split, Collections.singleton(field.name()))) {
                results.add(split);
                continue;
            }
            Object min = split.minValue(index, field, evolutions);
            Object max = split.maxValue(index, field, evolutions);
            Long nullCount = split.nullCount(index, evolutions);
            richSplits.add(new RichSplit(split, min, max, nullCount));
        }
        boolean nullFirst = SortValue.NullOrdering.NULLS_FIRST.equals((Object)order.nullOrdering());
        boolean ascending = SortValue.SortDirection.ASCENDING.equals((Object)order.direction());
        results.addAll(this.pickTopNSplits(richSplits, field.type(), ascending, nullFirst, limit));
        return results;
    }

    private List<DataSplit> pickTopNSplits(List<RichSplit> splits, DataType fieldType, boolean ascending, boolean nullFirst, int limit) {
        Comparator comparator = ascending ? (x, y) -> {
            int result;
            if (nullFirst) {
                result = this.nullsFirstCompare(((RichSplit)x).nullCount, ((RichSplit)y).nullCount);
                if (result == 0) {
                    result = this.ascCompare(fieldType, ((RichSplit)x).min, ((RichSplit)y).min);
                }
            } else {
                result = this.ascCompare(fieldType, ((RichSplit)x).min, ((RichSplit)y).min);
                if (result == 0) {
                    result = this.nullsLastCompare(((RichSplit)x).nullCount, ((RichSplit)y).nullCount);
                }
            }
            return result;
        } : (x, y) -> {
            int result;
            if (nullFirst) {
                result = this.nullsFirstCompare(((RichSplit)x).nullCount, ((RichSplit)y).nullCount);
                if (result == 0) {
                    result = this.descCompare(fieldType, ((RichSplit)x).max, ((RichSplit)y).max);
                }
            } else {
                result = this.descCompare(fieldType, ((RichSplit)x).max, ((RichSplit)y).max);
                if (result == 0) {
                    result = this.nullsLastCompare(((RichSplit)x).nullCount, ((RichSplit)y).nullCount);
                }
            }
            return result;
        };
        return splits.stream().sorted(comparator).map(rec$ -> ((RichSplit)rec$).split()).limit(limit).collect(Collectors.toList());
    }

    private int nullsFirstCompare(Long left, Long right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return -Long.compare(left, right);
    }

    private int nullsLastCompare(Long left, Long right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return Long.compare(left, right);
    }

    private int ascCompare(DataType type, Object left, Object right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return CompareUtils.compareLiteral(type, left, right);
    }

    private int descCompare(DataType type, Object left, Object right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return -CompareUtils.compareLiteral(type, left, right);
    }

    private TableSchema scanTableSchema(long id) {
        return this.tableSchemas.computeIfAbsent(id, key -> key.longValue() == this.schema.id() ? this.schema : this.schemaManager.schema(id));
    }

    private static class RichSplit {
        private final DataSplit split;
        private final Object min;
        private final Object max;
        private final Long nullCount;

        private RichSplit(DataSplit split, Object min, Object max, Long nullCount) {
            this.split = split;
            this.min = min;
            this.max = max;
            this.nullCount = nullCount;
        }

        private DataSplit split() {
            return this.split;
        }
    }
}

