/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.ExpirePartitionsAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class ExpirePartitionsActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "expire_partitions";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        this.checkRequiredArgument(params, "expiration_time");
        this.checkRequiredArgument(params, "timestamp_formatter");
        String expirationTime = params.get("expiration_time");
        String timestampFormatter = params.get("timestamp_formatter");
        String expireStrategy = params.get("expire_strategy");
        String timestampPattern = params.get("timestamp_pattern");
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        return Optional.of(new ExpirePartitionsAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, expirationTime, timestampFormatter, timestampPattern, expireStrategy));
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"expire_partitions\" expire table partitions by name.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  expire_partitions --warehouse <warehouse_path> --database <database_name> --table <table_name> --tag_name <tag_name> --expiration_time <expiration_time> --timestamp_formatter <timestamp_formatter>[--timestamp_pattern <timestamp_pattern>] [--expire_strategy <expire_strategy>]");
        System.out.println();
    }
}

