/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import org.apache.flink.cdc.connectors.postgres.source.PostgresSourceBuilder;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceOptions;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.postgres.PostgresTypeUtils;
import org.apache.paimon.flink.action.cdc.schema.JdbcSchemaUtils;
import org.apache.paimon.flink.action.cdc.schema.JdbcSchemasInfo;
import org.apache.paimon.flink.action.cdc.serialization.CdcDebeziumDeserializationSchema;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.schema.Schema;

public class PostgresActionUtils {
    static Connection getConnection(Configuration postgresConfig) throws Exception {
        String url = String.format("jdbc:postgresql://%s:%d/%s", postgresConfig.get(PostgresSourceOptions.HOSTNAME), postgresConfig.get(PostgresSourceOptions.PG_PORT), postgresConfig.get(PostgresSourceOptions.DATABASE_NAME));
        return DriverManager.getConnection(url, (String)postgresConfig.get(PostgresSourceOptions.USERNAME), (String)postgresConfig.get(PostgresSourceOptions.PASSWORD));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JdbcSchemasInfo getPostgresTableInfos(Configuration postgresConfig, Predicate<String> monitorTablePredication, List<Identifier> excludedTables, TypeMapping typeMapping) throws Exception {
        String databaseName = (String)postgresConfig.get(PostgresSourceOptions.DATABASE_NAME);
        Pattern schemaPattern = Pattern.compile((String)postgresConfig.get(PostgresSourceOptions.SCHEMA_NAME));
        JdbcSchemasInfo jdbcSchemasInfo = new JdbcSchemasInfo();
        try (Connection conn = PostgresActionUtils.getConnection(postgresConfig);){
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet schemas = metaData.getSchemas();){
                while (schemas.next()) {
                    ResultSet tables;
                    block36: {
                        String schemaName = schemas.getString("TABLE_SCHEM");
                        Matcher schemaMatcher = schemaPattern.matcher(schemaName);
                        if (!schemaMatcher.matches()) continue;
                        tables = metaData.getTables(databaseName, schemaName, "%", new String[]{"TABLE"});
                        Throwable throwable = null;
                        try {
                            while (tables.next()) {
                                String tableName = tables.getString("TABLE_NAME");
                                String tableComment = tables.getString("REMARKS");
                                Identifier identifier = Identifier.create(databaseName, tableName);
                                if (monitorTablePredication.test(tableName)) {
                                    Schema schema = JdbcSchemaUtils.buildSchema(metaData, databaseName, schemaName, tableName, tableComment, typeMapping, PostgresTypeUtils.toPaimonTypeVisitor());
                                    jdbcSchemasInfo.addSchema(identifier, schemaName, schema);
                                    continue;
                                }
                                excludedTables.add(identifier);
                            }
                            if (tables == null) continue;
                            if (throwable == null) break block36;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (tables == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        tables.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                tables.close();
                                throw throwable3;
                            }
                        }
                        try {
                            tables.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    tables.close();
                }
                return jdbcSchemasInfo;
            }
        }
    }

    public static JdbcIncrementalSource<CdcSourceRecord> buildPostgresSource(Configuration postgresConfig, String[] schemaList, String[] tableList) {
        PostgresSourceBuilder sourceBuilder = PostgresSourceBuilder.PostgresIncrementalSource.builder();
        sourceBuilder.hostname((String)postgresConfig.get(PostgresSourceOptions.HOSTNAME)).port(((Integer)postgresConfig.get(PostgresSourceOptions.PG_PORT)).intValue()).database((String)postgresConfig.get(PostgresSourceOptions.DATABASE_NAME)).schemaList(schemaList).tableList(tableList).slotName((String)postgresConfig.get(PostgresSourceOptions.SLOT_NAME)).username((String)postgresConfig.get(PostgresSourceOptions.USERNAME)).password((String)postgresConfig.get(PostgresSourceOptions.PASSWORD));
        postgresConfig.getOptional(PostgresSourceOptions.DECODING_PLUGIN_NAME).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).decodingPluginName(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).splitSize(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.CONNECT_TIMEOUT).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).connectTimeout(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.CONNECT_MAX_RETRIES).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).connectMaxRetries(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.CONNECTION_POOL_SIZE).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).connectionPoolSize(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.HEARTBEAT_INTERVAL).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).heartbeatInterval(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).closeIdleReaders(arg_0));
        postgresConfig.getOptional(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP).ifPresent(arg_0 -> ((PostgresSourceBuilder)sourceBuilder).skipSnapshotBackfill(arg_0));
        String startupMode = (String)postgresConfig.get(PostgresSourceOptions.SCAN_STARTUP_MODE);
        if ("initial".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.initial());
        } else if ("latest-offset".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.latest());
        }
        Properties debeziumProperties = new Properties();
        debeziumProperties.putAll(OptionsUtils.convertToPropertiesPrefixKey(postgresConfig.toMap(), "debezium."));
        sourceBuilder.debeziumProperties(debeziumProperties);
        HashMap<String, Object> customConverterConfigs = new HashMap<String, Object>();
        customConverterConfigs.put("decimal.format", "numeric");
        CdcDebeziumDeserializationSchema schema = new CdcDebeziumDeserializationSchema(true, customConverterConfigs);
        return sourceBuilder.deserializer((DebeziumDeserializationSchema)schema).includeSchemaChanges(true).build();
    }

    public static void registerJdbcDriver() {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("No suitable driver found. Cannot find class org.postgresql.Driver.");
        }
    }
}

