/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.Schema;
import org.apache.flink.util.Preconditions;

public class FlinkDescriptorProperties {
    public static final String NAME = "name";
    public static final String DATA_TYPE = "data-type";
    public static final String EXPR = "expr";
    public static final String METADATA = "metadata";
    public static final String VIRTUAL = "virtual";
    public static final String WATERMARK = "watermark";
    public static final String WATERMARK_ROWTIME = "rowtime";
    public static final String WATERMARK_STRATEGY = "strategy";
    public static final String WATERMARK_STRATEGY_EXPR = "strategy.expr";
    public static final String WATERMARK_STRATEGY_DATA_TYPE = "strategy.data-type";
    public static final String PRIMARY_KEY_NAME = "primary-key.name";
    public static final String PRIMARY_KEY_COLUMNS = "primary-key.columns";
    public static final String COMMENT = "comment";

    public static void removeSchemaKeys(String key, Schema schema, Map<String, String> options) {
        int idx;
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)schema);
        List<String> subKeys = Arrays.asList(NAME, DATA_TYPE, EXPR, METADATA, VIRTUAL);
        for (idx = 0; idx < schema.getColumns().size(); ++idx) {
            for (String subKey : subKeys) {
                options.remove(key + '.' + idx + '.' + subKey);
            }
        }
        if (!schema.getWatermarkSpecs().isEmpty()) {
            subKeys = Arrays.asList(WATERMARK_ROWTIME, WATERMARK_STRATEGY_EXPR, WATERMARK_STRATEGY_DATA_TYPE);
            for (idx = 0; idx < schema.getWatermarkSpecs().size(); ++idx) {
                for (String subKey : subKeys) {
                    options.remove(key + '.' + WATERMARK + '.' + idx + '.' + subKey);
                }
            }
        }
        schema.getPrimaryKey().ifPresent(pk -> {
            options.remove(key + '.' + PRIMARY_KEY_NAME);
            options.remove(key + '.' + PRIMARY_KEY_COLUMNS);
        });
    }
}

