/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.apache.paimon.rest.auth.BaseBearTokenCredentialsProvider;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.StringUtils;

public class BearTokenFileCredentialsProvider
extends BaseBearTokenCredentialsProvider {
    public static final double EXPIRED_FACTOR = 0.4;
    private final String tokenFilePath;
    private String token;
    private boolean keepRefreshed = false;
    private Long expiresAtMillis = null;
    private Long expiresInMills = null;

    public BearTokenFileCredentialsProvider(String tokenFilePath) {
        this.tokenFilePath = tokenFilePath;
        this.token = this.getTokenFromFile();
    }

    public BearTokenFileCredentialsProvider(String tokenFilePath, Long expiresInMills) {
        this(tokenFilePath);
        this.keepRefreshed = true;
        this.expiresAtMillis = -1L;
        this.expiresInMills = expiresInMills;
    }

    @Override
    String token() {
        return this.token;
    }

    @Override
    public boolean refresh() {
        long start = System.currentTimeMillis();
        String newToken = this.getTokenFromFile();
        if (StringUtils.isNullOrWhitespaceOnly(newToken)) {
            return false;
        }
        this.expiresAtMillis = start + this.expiresInMills;
        this.token = newToken;
        return true;
    }

    @Override
    public boolean supportRefresh() {
        return true;
    }

    @Override
    public boolean keepRefreshed() {
        return this.keepRefreshed;
    }

    @Override
    public boolean willSoonExpire() {
        if (this.keepRefreshed()) {
            return (double)(this.expiresAtMillis().get() - System.currentTimeMillis()) < (double)this.expiresInMills().get().longValue() * 0.4;
        }
        return false;
    }

    @Override
    public Optional<Long> expiresAtMillis() {
        return Optional.ofNullable(this.expiresAtMillis);
    }

    @Override
    public Optional<Long> expiresInMills() {
        return Optional.ofNullable(this.expiresInMills);
    }

    private String getTokenFromFile() {
        try {
            return FileIOUtils.readFileUtf8(new File(this.tokenFilePath));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

