/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class IncrementalTagStartingScanner
extends AbstractStartingScanner {
    private final Snapshot start;
    private final Snapshot end;

    public IncrementalTagStartingScanner(SnapshotManager snapshotManager, String startTagName, String endTagName) {
        super(snapshotManager);
        TagManager tagManager = new TagManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        this.start = tagManager.getOrThrow(startTagName).trimToSnapshot();
        this.end = tagManager.getOrThrow(endTagName).trimToSnapshot();
        if (this.end.id() <= this.start.id()) {
            throw new IllegalArgumentException(String.format("Tag end %s with snapshot id %s should be larger than tag start %s with snapshot id %s", endTagName, this.end.id(), startTagName, this.start.id()));
        }
        this.startingSnapshotId = this.start.id();
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader reader) {
        return StartingScanner.fromPlan(reader.withSnapshot(this.end).readIncrementalDiff(this.start));
    }
}

