/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BufferCompressionException;
import org.apache.paimon.compression.CompressorUtils;

public class Lz4BlockCompressor
implements BlockCompressor {
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return 8 + this.compressor.maxCompressedLength(srcSize);
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferCompressionException {
        try {
            int compressedLength = this.compressor.compress(src, srcOff, srcLen, dst, dstOff + 8);
            CompressorUtils.writeIntLE(compressedLength, dst, dstOff);
            CompressorUtils.writeIntLE(srcLen, dst, dstOff + 4);
            return 8 + compressedLength;
        }
        catch (Exception e) {
            throw new BufferCompressionException(e);
        }
    }
}

