/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.utils.StringUtils;

public class RenameTagAction
extends TableActionBase {
    private final String tagName;
    private final String targetTagName;

    public RenameTagAction(String databaseName, String tableName, Map<String, String> catalogConfig, String tagName, String targetTagName) {
        super(databaseName, tableName, catalogConfig);
        this.tagName = tagName;
        this.targetTagName = targetTagName;
    }

    @Override
    public void run() throws Exception {
        if (StringUtils.isEmpty(this.tagName) || StringUtils.isEmpty(this.targetTagName)) {
            throw new RuntimeException(String.format("The specified tag name [%s] or target tag name [%s] cannot be empty.", this.tagName, this.targetTagName));
        }
        this.table.renameTag(this.tagName, this.targetTagName);
    }
}

