/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.clone.CloneFileInfo;
import org.apache.paimon.flink.clone.CloneFilesUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyDataFileOperator
extends AbstractStreamOperator<CloneFileInfo>
implements OneInputStreamOperator<CloneFileInfo, CloneFileInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(CopyDataFileOperator.class);
    private final Map<String, String> sourceCatalogConfig;
    private final Map<String, String> targetCatalogConfig;
    private transient Catalog sourceCatalog;
    private transient Catalog targetCatalog;
    private transient Map<String, FileIO> srcFileIOs;
    private transient Map<String, FileIO> targetFileIOs;
    private transient Map<String, Path> targetLocations;

    public CopyDataFileOperator(Map<String, String> sourceCatalogConfig, Map<String, String> targetCatalogConfig) {
        this.sourceCatalogConfig = sourceCatalogConfig;
        this.targetCatalogConfig = targetCatalogConfig;
    }

    public void open() throws Exception {
        this.sourceCatalog = FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.sourceCatalogConfig));
        this.targetCatalog = FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.targetCatalogConfig));
        this.srcFileIOs = new HashMap<String, FileIO>();
        this.targetFileIOs = new HashMap<String, FileIO>();
        this.targetLocations = new HashMap<String, Path>();
    }

    public void processElement(StreamRecord<CloneFileInfo> streamRecord) throws Exception {
        CloneFileInfo cloneFileInfo = (CloneFileInfo)streamRecord.getValue();
        FileIO sourceTableFileIO = CloneFilesUtil.getFileIO(this.srcFileIOs, cloneFileInfo.getSourceIdentifier(), this.sourceCatalog);
        FileIO targetTableFileIO = CloneFilesUtil.getFileIO(this.targetFileIOs, cloneFileInfo.getTargetIdentifier(), this.targetCatalog);
        Path targetTableRootPath = CloneFilesUtil.getPath(this.targetLocations, cloneFileInfo.getTargetIdentifier(), this.targetCatalog);
        String filePathExcludeTableRoot = cloneFileInfo.getFilePathExcludeTableRoot();
        Path sourcePath = new Path(cloneFileInfo.getSourceFilePath());
        Path targetPath = new Path(targetTableRootPath + filePathExcludeTableRoot);
        try {
            if (targetTableFileIO.exists(targetPath) && targetTableFileIO.getFileSize(targetPath) == sourceTableFileIO.getFileSize(sourcePath)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping clone target file {} because it already exists and has the same size.", (Object)targetPath);
                }
                this.output.collect(streamRecord);
                return;
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("File {} does not exist. ignore it", (Object)sourcePath, (Object)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Begin copy file from {} to {}.", (Object)sourcePath, (Object)targetPath);
        }
        try {
            IOUtils.copyBytes(sourceTableFileIO.newInputStream(sourcePath), targetTableFileIO.newOutputStream(targetPath, true));
        }
        catch (FileNotFoundException e) {
            LOG.warn("File {} does not exist. ignore it", (Object)sourcePath, (Object)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End copy file from {} to {}.", (Object)sourcePath, (Object)targetPath);
        }
        this.output.collect(streamRecord);
    }

    public void close() throws Exception {
        if (this.sourceCatalog != null) {
            this.sourceCatalog.close();
        }
        if (this.targetCatalog != null) {
            this.targetCatalog.close();
        }
    }
}

