/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.lookup.PartitionLoader;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPartitionLoader
extends PartitionLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicPartitionLoader.class);
    private static final long serialVersionUID = 2L;
    private final Duration refreshInterval;
    private final int maxPartitionNum;
    private transient Comparator<InternalRow> comparator;
    private transient LocalDateTime lastRefresh;

    DynamicPartitionLoader(FileStoreTable table, Duration refreshInterval, int maxPartitionNum) {
        super(table);
        this.refreshInterval = refreshInterval;
        this.maxPartitionNum = maxPartitionNum;
    }

    @Override
    public void open() {
        super.open();
        RowType partitionType = this.table.rowType().project(this.table.partitionKeys());
        this.comparator = CodeGenUtils.newRecordComparator(partitionType.getFieldTypes());
    }

    @Override
    public boolean checkRefresh() {
        if (this.lastRefresh != null && !this.lastRefresh.plus(this.refreshInterval).isBefore(LocalDateTime.now())) {
            return false;
        }
        LOG.info("DynamicPartitionLoader(maxPartitionNum={},table={}) refreshed after {} second(s), refreshing", new Object[]{this.maxPartitionNum, this.table.name(), this.refreshInterval.toMillis() / 1000L});
        List<BinaryRow> newPartitions = this.getMaxPartitions();
        this.lastRefresh = LocalDateTime.now();
        if (newPartitions.size() != this.partitions.size()) {
            this.partitions = newPartitions;
            this.logNewPartitions();
            return true;
        }
        for (int i = 0; i < newPartitions.size(); ++i) {
            if (this.comparator.compare(newPartitions.get(i), (InternalRow)this.partitions.get(i)) == 0) continue;
            this.partitions = newPartitions;
            this.logNewPartitions();
            return true;
        }
        LOG.info("DynamicPartitionLoader(maxPartitionNum={},table={}) didn't find new partitions.", (Object)this.maxPartitionNum, (Object)this.table.name());
        return false;
    }

    private void logNewPartitions() {
        String partitionsStr = this.partitions.stream().map(partition -> InternalRowPartitionComputer.partToSimpleString(this.table.rowType().project(this.table.partitionKeys()), partition, "-", 200)).collect(Collectors.joining(","));
        LOG.info("DynamicPartitionLoader(maxPartitionNum={},table={}) finds new partitions: {}.", new Object[]{this.maxPartitionNum, this.table.name(), partitionsStr});
    }

    private List<BinaryRow> getMaxPartitions() {
        List<BinaryRow> newPartitions = this.table.newReadBuilder().newScan().listPartitions().stream().sorted(this.comparator.reversed()).collect(Collectors.toList());
        if (newPartitions.size() <= this.maxPartitionNum) {
            return newPartitions;
        }
        return newPartitions.subList(0, this.maxPartitionNum);
    }
}

