/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.regex.Pattern;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.StringUtils;

public class ClearConsumersProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "clear_consumers";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="including_consumers", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="excluding_consumers", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String includingConsumers, String excludingConsumers) throws Catalog.TableNotExistException {
        FileStoreTable fileStoreTable = (FileStoreTable)this.catalog.getTable(Identifier.fromString(tableId));
        ConsumerManager consumerManager = new ConsumerManager(fileStoreTable.fileIO(), fileStoreTable.location(), fileStoreTable.snapshotManager().branch());
        Pattern includingPattern = StringUtils.isNullOrWhitespaceOnly(includingConsumers) ? Pattern.compile(".*") : Pattern.compile(includingConsumers);
        Pattern excludingPattern = StringUtils.isNullOrWhitespaceOnly(excludingConsumers) ? null : Pattern.compile(excludingConsumers);
        consumerManager.clearConsumers(includingPattern, excludingPattern);
        return new String[]{"Success"};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

