/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcSchema;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;

@Experimental
public class RichCdcRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CdcRecord cdcRecord;
    private final CdcSchema cdcSchema;

    public RichCdcRecord(CdcRecord cdcRecord, CdcSchema cdcSchema) {
        this.cdcRecord = cdcRecord;
        this.cdcSchema = cdcSchema;
    }

    public boolean hasPayload() {
        return !this.cdcRecord.data().isEmpty();
    }

    public RowKind kind() {
        return this.cdcRecord.kind();
    }

    public CdcSchema cdcSchema() {
        return this.cdcSchema;
    }

    public CdcRecord toCdcRecord() {
        return this.cdcRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichCdcRecord that = (RichCdcRecord)o;
        return this.cdcRecord == that.cdcRecord && Objects.equals(this.cdcSchema, that.cdcSchema);
    }

    public int hashCode() {
        return Objects.hash(this.cdcRecord, this.cdcSchema);
    }

    public String toString() {
        return "{cdcRecord=" + this.cdcRecord + ", cdcSchema=" + this.cdcSchema + '}';
    }

    public static Builder builder(RowKind kind) {
        return new Builder(kind);
    }

    public static class Builder {
        private final RowKind kind;
        private final CdcSchema.Builder schemaBuilder = CdcSchema.newBuilder();
        private final Map<String, String> data = new HashMap<String, String>();

        public Builder(RowKind kind) {
            this.kind = kind;
        }

        public Builder field(String name, DataType type, String value) {
            return this.field(name, type, value, null);
        }

        public Builder field(String name, DataType type, String value, @Nullable String description) {
            this.schemaBuilder.column(name, type, description);
            this.data.put(name, value);
            return this;
        }

        public RichCdcRecord build() {
            return new RichCdcRecord(new CdcRecord(this.kind, this.data), this.schemaBuilder.build());
        }
    }
}

