/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.IOManagerImpl;
import org.apache.paimon.flink.NestedProjectedRowData;
import org.apache.paimon.flink.source.FileStoreSourceReader;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializer;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;
import org.apache.paimon.flink.source.PendingSplitsCheckpointSerializer;
import org.apache.paimon.flink.source.metrics.FileStoreSourceReaderMetrics;
import org.apache.paimon.table.source.ReadBuilder;

public abstract class FlinkSource
implements Source<RowData, FileStoreSourceSplit, PendingSplitsCheckpoint> {
    private static final long serialVersionUID = 1L;
    protected final ReadBuilder readBuilder;
    @Nullable
    protected final Long limit;
    @Nullable
    protected final NestedProjectedRowData rowData;

    public FlinkSource(ReadBuilder readBuilder, @Nullable Long limit, @Nullable NestedProjectedRowData rowData) {
        this.readBuilder = readBuilder;
        this.limit = limit;
        this.rowData = rowData;
    }

    public SourceReader<RowData, FileStoreSourceSplit> createReader(SourceReaderContext context) {
        IOManager ioManager = IOManager.create(IOManagerImpl.splitPaths((String)context.getConfiguration().get(CoreOptions.TMP_DIRS)));
        FileStoreSourceReaderMetrics sourceReaderMetrics = new FileStoreSourceReaderMetrics((MetricGroup)context.metricGroup());
        return new FileStoreSourceReader(context, this.readBuilder.newRead(), sourceReaderMetrics, ioManager, this.limit, NestedProjectedRowData.copy(this.rowData));
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> createEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context) throws Exception {
        return this.restoreEnumerator(context, null);
    }

    public FileStoreSourceSplitSerializer getSplitSerializer() {
        return new FileStoreSourceSplitSerializer();
    }

    public PendingSplitsCheckpointSerializer getEnumeratorCheckpointSerializer() {
        return new PendingSplitsCheckpointSerializer(this.getSplitSerializer());
    }
}

