/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.FormatTableOptions;

public class FormatCatalogTable
implements CatalogTable {
    private final FormatTable table;
    private Map<String, String> cachedOptions;

    public FormatCatalogTable(FormatTable table) {
        this.table = table;
    }

    public FormatTable table() {
        return this.table;
    }

    public Schema getUnresolvedSchema() {
        Schema.Builder builder = Schema.newBuilder();
        RowType logicalType = LogicalTypeConversion.toLogicalType(this.table.rowType());
        logicalType.getFields().forEach(field -> {
            builder.column(field.getName(), (AbstractDataType)TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
            if (field.getDescription().isPresent()) {
                builder.withComment((String)field.getDescription().get());
            }
        });
        return builder.build();
    }

    public boolean isPartitioned() {
        return !this.table.partitionKeys().isEmpty();
    }

    public List<String> getPartitionKeys() {
        return this.table.partitionKeys();
    }

    public CatalogTable copy(Map<String, String> map) {
        return new FormatCatalogTable((FormatTable)this.table.copy((Map)map));
    }

    public Map<String, String> getOptions() {
        if (this.cachedOptions == null) {
            this.cachedOptions = new HashMap<String, String>();
            String format = this.table.format().name().toLowerCase();
            Map<String, String> options = this.table.options();
            options.forEach((k, v) -> {
                if (k.startsWith(format + ".")) {
                    this.cachedOptions.put((String)k, (String)v);
                }
            });
            if (options.containsKey(FormatTableOptions.FIELD_DELIMITER.key())) {
                this.cachedOptions.put("csv.field-delimiter", options.get(FormatTableOptions.FIELD_DELIMITER.key()));
            }
            this.cachedOptions.put(FactoryUtil.CONNECTOR.key(), "filesystem");
            this.cachedOptions.put(FileSystemConnectorOptions.PATH.key(), this.table.location());
            this.cachedOptions.put(FactoryUtil.FORMAT.key(), format);
        }
        return this.cachedOptions;
    }

    public String getComment() {
        return this.table.comment().orElse("");
    }

    public CatalogTable copy() {
        return this.copy(Collections.emptyMap());
    }

    public Optional<String> getDescription() {
        return this.table.comment();
    }

    public Optional<String> getDetailedDescription() {
        return this.getDescription();
    }

    public DynamicTableSource createTableSource(DynamicTableFactory.Context context) {
        return FactoryUtil.createDynamicTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), new HashMap(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
    }

    public DynamicTableSink createTableSink(DynamicTableFactory.Context context) {
        return FactoryUtil.createDynamicTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), new HashMap(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
    }
}

