/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactCoordinateOperator;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactWorkerOperator;
import org.apache.paimon.flink.compact.changelog.ChangelogTaskTypeInfo;
import org.apache.paimon.flink.sink.AdaptiveParallelism;
import org.apache.paimon.flink.sink.AsyncLookupSinkWrite;
import org.apache.paimon.flink.sink.AutoTagForSavepointCommitterOperatorFactory;
import org.apache.paimon.flink.sink.BatchWriteGeneratorTagOperatorFactory;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.CommittableTypeInfo;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.CommitterOperatorFactory;
import org.apache.paimon.flink.sink.GlobalFullCompactionSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.utils.ManagedMemoryUtils;
import org.apache.paimon.flink.utils.ParallelismUtils;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializableRunnable;

public abstract class FlinkSink<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WRITER_NAME = "Writer";
    private static final String WRITER_WRITE_ONLY_NAME = "Writer(write-only)";
    private static final String GLOBAL_COMMITTER_NAME = "Global Committer";
    protected final FileStoreTable table;
    private final boolean ignorePreviousFiles;

    public FlinkSink(FileStoreTable table, boolean ignorePreviousFiles) {
        this.table = table;
        this.ignorePreviousFiles = ignorePreviousFiles;
    }

    private StoreSinkWrite.Provider createWriteProvider(CheckpointConfig checkpointConfig, boolean isStreaming, boolean hasSinkMaterializer) {
        boolean waitCompaction;
        SerializableRunnable assertNoSinkMaterializer = () -> Preconditions.checkArgument(!hasSinkMaterializer, String.format("Sink materializer must not be used with Paimon sink. Please set '%s' to '%s' in Flink's config.", ExecutionConfigOptions.TABLE_EXEC_SINK_UPSERT_MATERIALIZE.key(), ExecutionConfigOptions.UpsertMaterialize.NONE.name()));
        Options options = this.table.coreOptions().toConfiguration();
        CoreOptions.ChangelogProducer changelogProducer = this.table.coreOptions().changelogProducer();
        CoreOptions coreOptions = this.table.coreOptions();
        if (coreOptions.writeOnly()) {
            waitCompaction = false;
        } else {
            waitCompaction = coreOptions.prepareCommitWaitCompaction();
            int deltaCommits = -1;
            if (options.contains(CoreOptions.FULL_COMPACTION_DELTA_COMMITS)) {
                deltaCommits = options.get(CoreOptions.FULL_COMPACTION_DELTA_COMMITS);
            } else if (options.contains(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL)) {
                long fullCompactionThresholdMs = options.get(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL).toMillis();
                deltaCommits = (int)(fullCompactionThresholdMs / checkpointConfig.getCheckpointInterval());
            }
            if (changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION || deltaCommits >= 0) {
                int finalDeltaCommits = Math.max(deltaCommits, 1);
                return (table, commitUser, state, ioManager, memoryPool, metricGroup) -> {
                    assertNoSinkMaterializer.run();
                    return new GlobalFullCompactionSinkWrite(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, finalDeltaCommits, isStreaming, memoryPool, metricGroup);
                };
            }
        }
        if (coreOptions.laziedLookup()) {
            return (table, commitUser, state, ioManager, memoryPool, metricGroup) -> {
                assertNoSinkMaterializer.run();
                return new AsyncLookupSinkWrite(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, isStreaming, memoryPool, metricGroup);
            };
        }
        return (table, commitUser, state, ioManager, memoryPool, metricGroup) -> {
            assertNoSinkMaterializer.run();
            return new StoreSinkWriteImpl(table, commitUser, state, ioManager, this.ignorePreviousFiles, waitCompaction, isStreaming, memoryPool, metricGroup);
        };
    }

    public DataStreamSink<?> sinkFrom(DataStream<T> input) {
        return this.sinkFrom(input, CoreOptions.createCommitUser(this.table.coreOptions().toConfiguration()));
    }

    public DataStreamSink<?> sinkFrom(DataStream<T> input, String initialCommitUser) {
        DataStream<Committable> written = this.doWrite(input, initialCommitUser, null);
        return this.doCommit(written, initialCommitUser);
    }

    private boolean hasSinkMaterializer(DataStream<T> input) {
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Transformation> queue = new LinkedList<Transformation>();
        queue.add(input.getTransformation());
        visited.add(input.getTransformation().getId());
        while (!queue.isEmpty()) {
            Transformation transformation = (Transformation)queue.poll();
            if (transformation.getName().startsWith("SinkMaterializer")) {
                return true;
            }
            for (Transformation prev : transformation.getInputs()) {
                if (visited.contains(prev.getId())) continue;
                queue.add(prev);
                visited.add(prev.getId());
            }
        }
        return false;
    }

    public DataStream<Committable> doWrite(DataStream<T> input, String commitUser, @Nullable Integer parallelism) {
        StreamExecutionEnvironment env = input.getExecutionEnvironment();
        boolean isStreaming = FlinkSink.isStreaming(input);
        boolean writeOnly = this.table.coreOptions().writeOnly();
        SingleOutputStreamOperator written = input.transform((writeOnly ? WRITER_WRITE_ONLY_NAME : WRITER_NAME) + " : " + this.table.name(), (TypeInformation)new CommittableTypeInfo(), this.createWriteOperatorFactory(this.createWriteProvider(env.getCheckpointConfig(), isStreaming, this.hasSinkMaterializer(input)), commitUser));
        if (parallelism == null) {
            ParallelismUtils.forwardParallelism(written, input);
        } else {
            written.setParallelism(parallelism.intValue());
        }
        Options options = Options.fromMap(this.table.options());
        String uidSuffix = options.get(FlinkConnectorOptions.SINK_OPERATOR_UID_SUFFIX);
        if (options.get(FlinkConnectorOptions.SINK_OPERATOR_UID_SUFFIX) != null) {
            written = written.uid(FlinkConnectorOptions.generateCustomUid(WRITER_NAME, this.table.name(), uidSuffix));
        }
        if (options.get(FlinkConnectorOptions.SINK_USE_MANAGED_MEMORY).booleanValue()) {
            ManagedMemoryUtils.declareManagedMemory(written, options.get(FlinkConnectorOptions.SINK_MANAGED_WRITER_BUFFER_MEMORY));
        }
        if (!this.table.primaryKeys().isEmpty() && options.get(FlinkConnectorOptions.PRECOMMIT_COMPACT).booleanValue()) {
            SingleOutputStreamOperator newWritten = written.transform("Changelog Compact Coordinator", (TypeInformation)new EitherTypeInfo((TypeInformation)new CommittableTypeInfo(), (TypeInformation)new ChangelogTaskTypeInfo()), (OneInputStreamOperator)new ChangelogCompactCoordinateOperator(this.table.coreOptions())).forceNonParallel().transform("Changelog Compact Worker", (TypeInformation)new CommittableTypeInfo(), (OneInputStreamOperator)new ChangelogCompactWorkerOperator(this.table));
            ParallelismUtils.forwardParallelism(newWritten, written);
            written = newWritten;
        }
        return written;
    }

    public DataStreamSink<?> doCommit(DataStream<Committable> written, String commitUser) {
        boolean streamingCheckpointEnabled;
        StreamExecutionEnvironment env = written.getExecutionEnvironment();
        ReadableConfig conf = env.getConfiguration();
        CheckpointConfig checkpointConfig = env.getCheckpointConfig();
        boolean bl = streamingCheckpointEnabled = FlinkSink.isStreaming(written) && checkpointConfig.isCheckpointingEnabled();
        if (streamingCheckpointEnabled) {
            FlinkSink.assertStreamingConfiguration(env);
        }
        Options options = Options.fromMap(this.table.options());
        AbstractStreamOperatorFactory committerOperator = new CommitterOperatorFactory<Committable, ManifestCommittable>(streamingCheckpointEnabled, true, commitUser, this.createCommitterFactory(), this.createCommittableStateManager(), options.get(FlinkConnectorOptions.END_INPUT_WATERMARK));
        if (options.get(FlinkConnectorOptions.SINK_AUTO_TAG_FOR_SAVEPOINT).booleanValue()) {
            committerOperator = new AutoTagForSavepointCommitterOperatorFactory<Committable, ManifestCommittable>((CommitterOperatorFactory<Committable, ManifestCommittable>)committerOperator, this.table::snapshotManager, this.table::tagManager, () -> this.table.store().newTagDeletion(), () -> this.table.store().createTagCallbacks(), this.table.coreOptions().tagDefaultTimeRetained());
        }
        if (conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.BATCH && this.table.coreOptions().tagCreationMode() == CoreOptions.TagCreationMode.BATCH) {
            committerOperator = new BatchWriteGeneratorTagOperatorFactory<Committable, ManifestCommittable>((CommitterOperatorFactory<Committable, ManifestCommittable>)committerOperator, this.table);
        }
        SingleOutputStreamOperator committed = written.transform("Global Committer : " + this.table.name(), (TypeInformation)new CommittableTypeInfo(), committerOperator).setParallelism(1).setMaxParallelism(1);
        if (options.get(FlinkConnectorOptions.SINK_OPERATOR_UID_SUFFIX) != null) {
            committed = committed.uid(FlinkConnectorOptions.generateCustomUid(GLOBAL_COMMITTER_NAME, this.table.name(), options.get(FlinkConnectorOptions.SINK_OPERATOR_UID_SUFFIX)));
        }
        if (!options.get(FlinkConnectorOptions.SINK_COMMITTER_OPERATOR_CHAINING).booleanValue()) {
            committed = committed.startNewChain();
        }
        FlinkSink.configureGlobalCommitter(committed, options.get(FlinkConnectorOptions.SINK_COMMITTER_CPU), options.get(FlinkConnectorOptions.SINK_COMMITTER_MEMORY));
        return committed.sinkTo((Sink)new DiscardingSink()).name("end").setParallelism(1);
    }

    public static void configureGlobalCommitter(SingleOutputStreamOperator<?> committed, double cpuCores, @Nullable MemorySize heapMemory) {
        if (heapMemory == null) {
            return;
        }
        SlotSharingGroup slotSharingGroup = SlotSharingGroup.newBuilder((String)committed.getName()).setCpuCores(cpuCores).setTaskHeapMemory(new org.apache.flink.configuration.MemorySize(heapMemory.getBytes())).build();
        committed.slotSharingGroup(slotSharingGroup);
    }

    public static void assertStreamingConfiguration(StreamExecutionEnvironment env) {
        Preconditions.checkArgument(!env.getCheckpointConfig().isUnalignedCheckpointsEnabled(), "Paimon sink currently does not support unaligned checkpoints. Please set execution.checkpointing.unaligned.enabled to false.");
        Preconditions.checkArgument(env.getCheckpointConfig().getCheckpointingMode() == CheckpointingMode.EXACTLY_ONCE, "Paimon sink currently only supports EXACTLY_ONCE checkpoint mode. Please set execution.checkpointing.mode to exactly-once");
    }

    public static void assertBatchAdaptiveParallelism(StreamExecutionEnvironment env, int sinkParallelism) {
        String msg = "Paimon Sink does not support Flink's Adaptive Parallelism mode. Please manually turn it off or set Paimon `sink.parallelism` manually.";
        FlinkSink.assertBatchAdaptiveParallelism(env, sinkParallelism, msg);
    }

    public static void assertBatchAdaptiveParallelism(StreamExecutionEnvironment env, int sinkParallelism, String exceptionMsg) {
        try {
            Preconditions.checkArgument(sinkParallelism != -1 || !AdaptiveParallelism.isEnabled(env), exceptionMsg);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected abstract OneInputStreamOperatorFactory<T, Committable> createWriteOperatorFactory(StoreSinkWrite.Provider var1, String var2);

    protected abstract Committer.Factory<Committable, ManifestCommittable> createCommitterFactory();

    protected abstract CommittableStateManager<ManifestCommittable> createCommittableStateManager();

    public static boolean isStreaming(DataStream<?> input) {
        return FlinkSink.isStreaming(input.getExecutionEnvironment());
    }

    public static boolean isStreaming(StreamExecutionEnvironment env) {
        return env.getConfiguration().get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
    }
}

