/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sorter;

import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.utils.Preconditions;

public class TableSortInfo {
    private final List<String> sortColumns;
    private final CoreOptions.OrderType sortStrategy;
    private final boolean sortInCluster;
    private final int rangeNumber;
    private final int sinkParallelism;
    private final int localSampleSize;
    private final int globalSampleSize;

    private TableSortInfo(List<String> sortColumns, CoreOptions.OrderType sortStrategy, boolean sortInCluster, int rangeNumber, int sinkParallelism, int localSampleSize, int globalSampleSize) {
        this.sortColumns = sortColumns;
        this.sortStrategy = sortStrategy;
        this.sortInCluster = sortInCluster;
        this.rangeNumber = rangeNumber;
        this.sinkParallelism = sinkParallelism;
        this.localSampleSize = localSampleSize;
        this.globalSampleSize = globalSampleSize;
    }

    public List<String> getSortColumns() {
        return this.sortColumns;
    }

    public CoreOptions.OrderType getSortStrategy() {
        return this.sortStrategy;
    }

    public boolean isSortInCluster() {
        return this.sortInCluster;
    }

    public int getRangeNumber() {
        return this.rangeNumber;
    }

    public int getLocalSampleSize() {
        return this.localSampleSize;
    }

    public int getGlobalSampleSize() {
        return this.globalSampleSize;
    }

    public int getSinkParallelism() {
        return this.sinkParallelism;
    }

    public static class Builder {
        private List<String> sortColumns = Collections.emptyList();
        private CoreOptions.OrderType sortStrategy = CoreOptions.OrderType.ORDER;
        private boolean sortInCluster = true;
        private int rangeNumber = -1;
        private int sinkParallelism = -1;
        private int localSampleSize = -1;
        private int globalSampleSize = -1;

        public Builder setSortColumns(List<String> sortColumns) {
            this.sortColumns = sortColumns;
            return this;
        }

        public Builder setSortStrategy(CoreOptions.OrderType sortStrategy) {
            this.sortStrategy = sortStrategy;
            return this;
        }

        public Builder setSortInCluster(boolean sortInCluster) {
            this.sortInCluster = sortInCluster;
            return this;
        }

        public Builder setRangeNumber(int rangeNumber) {
            this.rangeNumber = rangeNumber;
            return this;
        }

        public Builder setSinkParallelism(int sinkParallelism) {
            this.sinkParallelism = sinkParallelism;
            return this;
        }

        public Builder setLocalSampleSize(int localSampleSize) {
            this.localSampleSize = localSampleSize;
            return this;
        }

        public Builder setGlobalSampleSize(int globalSampleSize) {
            this.globalSampleSize = globalSampleSize;
            return this;
        }

        public TableSortInfo build() {
            Preconditions.checkArgument(!this.sortColumns.isEmpty(), "Sort columns cannot be empty");
            Preconditions.checkNotNull(this.sortStrategy, "Sort strategy cannot be null");
            Preconditions.checkArgument(this.sinkParallelism > 0, "The sink parallelism must be specified when sorting the table data. Please set it using the key: %s", FlinkConnectorOptions.SINK_PARALLELISM.key());
            Preconditions.checkArgument(this.rangeNumber > 0, "Range number must be positive");
            Preconditions.checkArgument(this.localSampleSize > 0, "Local sample size must be positive");
            Preconditions.checkArgument(this.globalSampleSize > 0, "Global sample size must be positive");
            return new TableSortInfo(this.sortColumns, this.sortStrategy, this.sortInCluster, this.rangeNumber, this.sinkParallelism, this.localSampleSize, this.globalSampleSize);
        }
    }
}

