/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.time.Duration;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.ChangelogDeletion;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.FileStoreWrite;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.privilege.PrivilegeChecker;
import org.apache.paimon.service.ServiceManager;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.TagAutoManager;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class PrivilegedFileStore<T>
implements FileStore<T> {
    private final FileStore<T> wrapped;
    private final PrivilegeChecker privilegeChecker;
    private final Identifier identifier;

    public PrivilegedFileStore(FileStore<T> wrapped, PrivilegeChecker privilegeChecker, Identifier identifier) {
        this.wrapped = wrapped;
        this.privilegeChecker = privilegeChecker;
        this.identifier = identifier;
    }

    @Override
    public FileStorePathFactory pathFactory() {
        return this.wrapped.pathFactory();
    }

    @Override
    public SnapshotManager snapshotManager() {
        this.privilegeChecker.assertCanSelectOrInsert(this.identifier);
        return this.wrapped.snapshotManager();
    }

    @Override
    public ChangelogManager changelogManager() {
        this.privilegeChecker.assertCanSelectOrInsert(this.identifier);
        return this.wrapped.changelogManager();
    }

    @Override
    public RowType partitionType() {
        return this.wrapped.partitionType();
    }

    @Override
    public CoreOptions options() {
        return this.wrapped.options();
    }

    @Override
    public BucketMode bucketMode() {
        return this.wrapped.bucketMode();
    }

    @Override
    public FileStoreScan newScan() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newScan();
    }

    @Override
    public ManifestList.Factory manifestListFactory() {
        return this.wrapped.manifestListFactory();
    }

    @Override
    public ManifestFile.Factory manifestFileFactory() {
        return this.wrapped.manifestFileFactory();
    }

    @Override
    public IndexManifestFile.Factory indexManifestFileFactory() {
        return this.wrapped.indexManifestFileFactory();
    }

    @Override
    public IndexFileHandler newIndexFileHandler() {
        return this.wrapped.newIndexFileHandler();
    }

    @Override
    public StatsFileHandler newStatsFileHandler() {
        return this.wrapped.newStatsFileHandler();
    }

    @Override
    public SplitRead<T> newRead() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newRead();
    }

    @Override
    public FileStoreWrite<T> newWrite(String commitUser) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWrite(commitUser);
    }

    @Override
    public FileStoreWrite<T> newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWrite(commitUser, manifestFilter);
    }

    @Override
    public FileStoreCommit newCommit(String commitUser, FileStoreTable table) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newCommit(commitUser, table);
    }

    @Override
    public SnapshotDeletion newSnapshotDeletion() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newSnapshotDeletion();
    }

    @Override
    public ChangelogDeletion newChangelogDeletion() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newChangelogDeletion();
    }

    @Override
    public TagManager newTagManager() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newTagManager();
    }

    @Override
    public TagDeletion newTagDeletion() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newTagDeletion();
    }

    @Override
    @Nullable
    public PartitionExpire newPartitionExpire(String commitUser, FileStoreTable table) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newPartitionExpire(commitUser, table);
    }

    @Override
    public PartitionExpire newPartitionExpire(String commitUser, FileStoreTable table, Duration expirationTime, Duration checkInterval, PartitionExpireStrategy expireStrategy) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newPartitionExpire(commitUser, table, expirationTime, checkInterval, expireStrategy);
    }

    @Override
    public TagAutoManager newTagCreationManager() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newTagCreationManager();
    }

    @Override
    public ServiceManager newServiceManager() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newServiceManager();
    }

    @Override
    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.mergeSchema(rowType, allowExplicitCast);
    }

    @Override
    public List<TagCallback> createTagCallbacks() {
        return this.wrapped.createTagCallbacks();
    }

    @Override
    public void setManifestCache(SegmentsCache<Path> manifestCache) {
        this.wrapped.setManifestCache(manifestCache);
    }

    @Override
    public void setSnapshotCache(Cache<Path, Snapshot> cache) {
        this.wrapped.setSnapshotCache(cache);
    }
}

