/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.system.AggregationFieldsTable;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;

public class AllTableOptionsTable
implements ReadonlyTable {
    public static final String ALL_TABLE_OPTIONS = "all_table_options";
    private final Map<Identifier, Map<String, String>> allOptions;

    public AllTableOptionsTable(Map<Identifier, Map<String, String>> allOptions) {
        this.allOptions = allOptions;
    }

    @Override
    public String name() {
        return ALL_TABLE_OPTIONS;
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "database_name", new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(1, "table_name", new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(2, "key", new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(3, "value", new VarCharType(Integer.MAX_VALUE)));
        return new RowType(fields);
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("table_name");
    }

    @Override
    public FileIO fileIO() {
        return new LocalFileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new AllTableOptionsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new AllTableOptionsRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new AllTableOptionsTable(this.allOptions);
    }

    private static class AllTableOptionsRead
    implements InnerTableRead {
        private RowType readType;

        private AllTableOptionsRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof AllTableSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            ArrayList<GenericRow> rows = new ArrayList<GenericRow>();
            for (Map.Entry entry : ((AllTableSplit)split).allOptions.entrySet()) {
                String database = ((Identifier)entry.getKey()).getDatabaseName();
                String tableName = ((Identifier)entry.getKey()).getTableName();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    String key = (String)entry2.getKey();
                    String value = (String)entry2.getValue();
                    rows.add(GenericRow.of(BinaryString.fromString(database), BinaryString.fromString(tableName), BinaryString.fromString(key), BinaryString.fromString(value)));
                }
            }
            Iterator<Object> iterator2 = rows.iterator();
            if (this.readType != null) {
                iterator2 = Iterators.transform(iterator2, row -> ProjectedRow.from(this.readType, AggregationFieldsTable.TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(iterator2);
        }
    }

    private static class AllTableSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Map<Identifier, Map<String, String>> allOptions;

        private AllTableSplit(Map<Identifier, Map<String, String>> allOptions) {
            this.allOptions = allOptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTableSplit that = (AllTableSplit)o;
            return Objects.equals(this.allOptions, that.allOptions);
        }

        public int hashCode() {
            return Objects.hash(this.allOptions);
        }
    }

    private class AllTableOptionsScan
    extends ReadOnceTableScan {
        private AllTableOptionsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new AllTableSplit(AllTableOptionsTable.this.allOptions));
        }
    }
}

