/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.paimon.append.AppendCompactCoordinator;
import org.apache.paimon.append.MultiTableAppendCompactTask;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;

public class MultiAppendCompactTableScan
extends MultiTableScanBase<MultiTableAppendCompactTask> {
    protected transient Map<Identifier, AppendCompactCoordinator> tablesMap = new HashMap<Identifier, AppendCompactCoordinator>();

    public MultiAppendCompactTableScan(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, boolean isStreaming, Map<String, String> tableOptions) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, isStreaming, tableOptions);
    }

    @Override
    List<MultiTableAppendCompactTask> doScan() {
        ArrayList<MultiTableAppendCompactTask> tasks = new ArrayList<MultiTableAppendCompactTask>();
        for (Map.Entry<Identifier, AppendCompactCoordinator> tableIdAndCoordinator : this.tablesMap.entrySet()) {
            Identifier tableId = tableIdAndCoordinator.getKey();
            AppendCompactCoordinator compactionCoordinator = tableIdAndCoordinator.getValue();
            compactionCoordinator.run().stream().map(task -> new MultiTableAppendCompactTask(task.partition(), task.compactBefore(), tableId)).forEach(tasks::add);
        }
        return tasks;
    }

    @Override
    public boolean checkTableScanned(Identifier identifier) {
        return this.tablesMap.containsKey(identifier);
    }

    @Override
    public void addScanTable(FileStoreTable fileStoreTable, Identifier identifier) {
        if (fileStoreTable.bucketMode() == BucketMode.BUCKET_UNAWARE) {
            this.tablesMap.put(identifier, new AppendCompactCoordinator(fileStoreTable, this.isStreaming));
        }
    }
}

