/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateDatabaseProcedure
extends ProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateDatabaseProcedure.class);

    @Override
    public String identifier() {
        return "migrate_database";
    }

    @ProcedureHint(argument={@ArgumentHint(name="connector", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="source_database", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="Integer"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String connector, String sourceDatabasePath, String properties, Integer parallelism) throws Exception {
        properties = this.notnull(properties);
        Integer p = parallelism == null ? Runtime.getRuntime().availableProcessors() : parallelism.intValue();
        List<Migrator> migrators = TableMigrationUtils.getImporters(connector, this.catalog, sourceDatabasePath, p, ParameterUtils.parseCommaSeparatedKeyValues(properties));
        int errorCount = 0;
        int successCount = 0;
        for (Migrator migrator : migrators) {
            try {
                migrator.executeMigrate();
                migrator.renameTable(false);
                ++successCount;
            }
            catch (Exception e) {
                ++errorCount;
                LOG.error("Call migrate_database error:" + e.getMessage());
            }
        }
        String retStr = String.format("migrate database is finished, success cnt: %s , failed cnt: %s", String.valueOf(successCount), String.valueOf(errorCount));
        return new String[]{retStr};
    }
}

